#ifndef POOL_H
#define POOL_H

typedef unsigned int uint;

#ifndef NULL
#define NULL 0
#endif

template<class ItemType>
class Pool
{
public:
	struct Iterator
	{
		ItemType *pData;
	private:
		friend class Pool;
		Iterator *pNext,*pPrev;
	private:
		Iterator():pNext(NULL),pPrev(NULL){}
		~Iterator(){delete pData;}
	};
private:
	Iterator		*m_pItems;						//Holds all pool items

	Iterator		*m_pUsed;						//List for used items
	Iterator		*m_pUnused;						//List for unused items

	uint			 m_nCount;						//Item count
private:
	void			 Initialize()
	{
		m_pUsed		=  NULL;
		m_pUnused	= &m_pItems[0];
		
		for(uint i=1;i<m_nCount;i++)
		{
			m_pItems[i-1].pNext = &m_pItems[i];
			m_pItems[i].pPrev	= &m_pItems[i-1];
		}
	}
private:
	//This is reserved for Create functions
	Pool()
	{
		
	}
	Pool(uint nCount):m_nCount(nCount)
	{
		m_pItems = new Iterator[m_nCount];
	}
public:

	~Pool()
	{
		delete[]m_pItems;
	}

	//Allocate all the items
	void				AllocateAll	()
	{
		while(Allocate()){}
	}

	bool			    IsAllDeleted   ()const
	{
		return m_pUsed==NULL;
	}
	//Allocates a free item from the pool
	//If there are no items returns NULL
	Iterator		*	Allocate	()
	{
		if(m_pUnused)
		{
			Iterator *pAllocated = m_pUnused;

			if(m_pUnused->pNext)m_pUnused->pNext->pPrev = NULL;		//Set new pPrev for the next unused element

			//Make new root (if there were no more elements, new root will be NULL)
			m_pUnused = m_pUnused->pNext;

			if(m_pUsed==NULL)
			{
				//This is the first used element
				m_pUsed = pAllocated;
				pAllocated->pNext = NULL;
			}
			else
			{
				m_pUsed->pPrev    = pAllocated;
				pAllocated->pNext = m_pUsed;
				m_pUsed			  = pAllocated;
			}
			return pAllocated;
		}
		else
		{
			return NULL;
		}
	}

	//Returns all the used items to unused list
	void				DeleteAll	()
	{
		while(m_pUsed)Delete(m_pUsed);
	}

	//Deallocates used item and returns it to unused list
	void				Delete		(Iterator *pItem)
	{
		if(pItem->pPrev)pItem->pPrev->pNext = pItem->pNext;		//Set new pNext for previous element (if exists)
		else m_pUsed = pItem->pNext;							//If item has no pPrev it must be root, set next element to it
		if(pItem->pNext)pItem->pNext->pPrev = pItem->pPrev;		//Set new pPrev for next     element (if exists)

		Iterator *pDeleted = pItem;

		if(m_pUnused==NULL)
		{
			//New unused root
			m_pUnused = pDeleted;
			m_pUnused->pPrev = NULL;
			m_pUnused->pNext = NULL;
		}
		else
		{
			m_pUnused->pPrev = pDeleted;
			pDeleted->pNext  = m_pUnused;
			pDeleted->pPrev  = NULL;
			m_pUnused = pDeleted;
		}
	
	}

	//Iterated through used items
	Iterator		*	Next		(Iterator *pItem = NULL)
	{
		return pItem==NULL?m_pUsed:pItem->pNext;
	}

	Iterator		*	Prev		(Iterator *pItem = NULL)
	{
		return pItem==NULL?NULL:pItem->pPrev;
	}
public:
	//Creates pool and calls constructor (with no parameters) for every item
	static Pool<ItemType> *		Create(uint nCount)
	{
		Pool<ItemType> *pNewPool = new Pool<ItemType>(nCount);
		for(uint i=0;i<nCount;i++)pNewPool->m_pItems[i].pData = new ItemType();
		pNewPool->Initialize();
		return pNewPool;
	}

	static Pool<ItemType> *		Create(uint nCount, ItemType*(*fnCreateFunc)(uint))
	{
		Pool<ItemType> *pNewPool = new Pool<ItemType>(nCount);
		for(uint i=0;i<nCount;i++)pNewPool->m_pItems[i].pData = (*fnCreateFunc)(i);
		pNewPool->Initialize();
		return pNewPool;
	}
	//Creates pool and calls constructor (with 1 parameter) for every item
	template<typename P1>
	static Pool<ItemType> *		Create(uint nCount,P1 p1)
	{
		Pool<ItemType> *pNewPool = new Pool<ItemType>(nCount);
		for(uint i=0;i<nCount;i++)pNewPool->m_pItems[i].pData = new ItemType(p1);
		pNewPool->Initialize();
		return pNewPool;
	}
	//Creates pool and calls constructor (with 2 parameters) for every item
	template<typename P1,typename P2>
	static Pool<ItemType> *		Create(uint nCount,P1 p1,P2 p2)
	{
		Pool<ItemType> *pNewPool = new Pool<ItemType>(nCount);
		for(uint i=0;i<nCount;i++)pNewPool->m_pItems[i].pData = new ItemType(p1,p2);
		pNewPool->Initialize();
		return pNewPool;
	}

	//Creates pool and calls constructor (with 3 parameters) for every item
	template<typename P1,typename P2,typename P3>
	static Pool<ItemType> *		Create(uint nCount,P1 p1,P2 p2,P3 p3)
	{
		Pool<ItemType> *pNewPool = new Pool<ItemType>(nCount);
		for(uint i=0;i<nCount;i++)pNewPool->m_pItems[i].pData = new ItemType(p1,p2,p3);
		pNewPool->Initialize();
		return pNewPool;
	}

	//Creates pool and calls constructor (with 4 parameters) for every item
	template<typename P1,typename P2,typename P3,typename P4>
	static Pool<ItemType> *		Create(uint nCount,P1 p1,P2 p2,P3 p3,P4 p4)
	{
		Pool<ItemType> *pNewPool = new Pool<ItemType>(nCount);
		for(uint i=0;i<nCount;i++)pNewPool->m_pItems[i].pData = new ItemType(p1,p2,p3,p4);
		pNewPool->Initialize();
		return pNewPool;
	}

};

#endif
