#ifndef PRIMITIVES_H
#define PRIMITIVES_H

#include "Types/Vector3D.h"


void DrawLeftQuad(const Vector2D& vLeft, float height, float length,const Vector3D& vStartColor = Vector3D(1,1,1),const Vector3D& vEndColor = Vector3D(1,1,1),float t = 1.0f)
{
	Vector3D tmpEndColor = lerp(vStartColor,vEndColor,t);

	glBegin(GL_QUADS);
		glColor3fv(vStartColor);
		glTexCoord2f(0.0f,1.0f);
		glVertex2f(vLeft.x,vLeft.y-height*0.5f);
		glColor3fv(tmpEndColor);
		glTexCoord2f(1.0f,1.0f);
		glVertex2f(vLeft.x+length*t,vLeft.y-height*0.5f);
		glColor3fv(tmpEndColor);
		glTexCoord2f(1.0f,0.0f);
		glVertex2f(vLeft.x+length*t,vLeft.y+height*0.5f);
		glColor3fv(vStartColor);
		glTexCoord2f(0.0f,0.0f);
		glVertex2f(vLeft.x,vLeft.y+height*0.5f);
	glEnd();
}

#endif