#include "Rocket.h"
#include "Managers/CModelManager.hpp"
#include "Types/Math1D.h"
#include "Utils/CKeys.h"
#include "Types/Quaternion.h"
#include "DefconSettings.h"


#include "ErrorCheck.h"

Rocket::Rocket():CRenderObject(g_pcModelMan->GetModel("Rocket.tct"))
{
	m_bAlive = false;
	m_vVelocity = Vector3D(0,0,0);
	m_vCollisionPoint = Vector3D(0,0,0);
}
Rocket::~Rocket()
{
}


void Rocket::CalcRotation()
{
	Vector3D vLook = m_vVelocity;vLook.normalize();
	Vector3D vUp(0,0,1);
	Vector3D vRight= Cross(vUp,vLook);vRight.normalize();
	vUp			   = Cross(vLook,vRight);vUp.normalize();

	Matrix3D mm = Matrix3D::getIdentityMatrix();
	mm[0][0] = vLook.x;	mm[1][0] = vLook.y;	mm[2][0] = vLook.z;
	mm[0][1] = vRight.x;mm[1][1] = vRight.y;mm[2][1] = vRight.z;
	mm[0][2] = vUp.x;	mm[1][2] = vUp.y;	mm[2][2] = vUp.z;

	Matrix3D m,rot = Matrix3D::getRotateZMatrix(-PI/2);
	m = mm*rot;

	SetRotation(m);
}
void Rocket::Fire  (const Vector3D& vPosition,const Vector3D& vStartVelocity)
{
	SetPosition(vPosition);
	m_vVelocity = vStartVelocity;
	m_vForce    = Vector3D(0,0,0);
	m_bAlive = true;
}

void Rocket::Update(float fDeltaTime)
{
	CalcRotation();
	if(IsAlive())
	{
		Vector3D lastPos = GetPosition();
		Vector3D v = GetPosition();
		m_vForce = -v;
		m_vForce.normalize();
		m_vForce*=Defcon::fPlanetGravityForce;

		m_vVelocity+=m_vForce*fDeltaTime;			
		//Some random

		Vector3D vRandVec = GetPosition();vRandVec.normalize();
		Quaternion qRandVec(PI/2,vRandVec);
		Vector3D vRightVec = qRandVec.rotate(m_vVelocity*fRandom(-0.1f,0.1f));


		m_vVelocity+=vRightVec*fDeltaTime*3.0f;


		m_vVelocity+=-(m_vVelocity)*fDeltaTime*Defcon::fRocketDamping;	
		v+= m_vVelocity*fDeltaTime;
		SetPosition(v);

		if(v.length()<100.0f)
		{
			m_bAlive = false;
			m_vCollisionPoint = lastPos;

		}
	}
}

