#ifndef ROCKET_H
#define ROCKET_H

#include "Models/CRenderObject.hpp"



class Rocket:public CRenderObject
{
	bool		m_bAlive;

	Vector3D	m_vVelocity;

	Vector3D	m_vForce;

	Vector3D	m_vCollisionPoint;
	
public:
	Rocket();
	~Rocket();

	void			CalcRotation();

	void			Update(float fDeltaTime);

	void			Fire  (const Vector3D& vPosition,const Vector3D& vStartVelocity);

	inline bool 	IsAlive()const{return m_bAlive;}
	inline Vector3D GetColPoint()const{return m_vCollisionPoint;}
};


#endif
