#include "Smoke.h"
#include "Billboard.h"
#include "Texture/CTexture.h"

#include "Types/Math1D.h"
#include "Types/Math3D.h"

#include "ErrorCheck.h"


Smoke::Smoke(CTexture *pTexture)
{
	m_pSmokeTexture = pTexture;
	m_nSmokeCnt = 100;
	m_pSmokePool = SmokePool::Create(m_nSmokeCnt);
}
Smoke::~Smoke()
{
	delete m_pSmokePool;
}

void Smoke::Reset(const Vector3D& vSmokeCenter )
{
	m_vSmokeCenter = vSmokeCenter;
	m_fSmokeSpawn  = 0.0f;
	m_fLife        = 10.0f;
	m_pSmokePool->DeleteAll();
}

void Smoke::Update(float fDeltaTime)
{
	if(IsAlive())
	{	
		m_fLife-=fDeltaTime;
		m_fSmokeSpawn-=fDeltaTime;
		if(m_fSmokeSpawn<0.3f && m_fLife>0.0f)
		{
			m_fSmokeSpawn+=0.3f;
			SmokePool::Iterator* pItem = m_pSmokePool->Allocate();
			if(pItem)
			{
				pItem->pData->v = m_vSmokeCenter;
				pItem->pData->a = 1.0f;
				pItem->pData->s = 11.0f;
				pItem->pData->r = fRandom(PI);
				pItem->pData->velCof   = GetRandomVector();
				pItem->pData->rotCof   = fRandom(4.1f,20.1f);
				pItem->pData->alphaCof = fRandom(0.1f,1.0f);

			}
		}

		SmokePool::Iterator * pPrevItem = NULL;
		for(SmokePool::Iterator* pItem = m_pSmokePool->Next(NULL);
			pItem!=NULL;
			pItem = m_pSmokePool->Next(pItem))
		{
			Vector3D vDir = pItem->pData->v;
			vDir.normalize(); 
			vDir = (vDir*0.9f+pItem->pData->velCof*0.1f)*3.0f;
			pItem->pData->v+=vDir*fDeltaTime;
			pItem->pData->s+= fDeltaTime*2.0f;
			pItem->pData->r = fWrap(pItem->pData->r+pItem->pData->rotCof*fDeltaTime,TWO_PI);
			pItem->pData->a = fMax(pItem->pData->a-pItem->pData->alphaCof*fDeltaTime,0.0f);
			if(pItem->pData->a<=0.0f)
			{
				m_pSmokePool->Delete(pItem);
				pItem = pPrevItem;
			}
			else
			{
				pPrevItem = pItem;
			}
		}
	}
}

void Smoke::Render()
{
	glBindTexture(GL_TEXTURE_2D,m_pSmokeTexture->GetTextureId());
	glDisable(GL_LIGHTING);
	glEnable(GL_BLEND);
	glDepthMask(GL_FALSE);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

	for(SmokePool::Iterator* pItem = m_pSmokePool->Next(NULL);
		pItem!=NULL;
		pItem = m_pSmokePool->Next(pItem))
	{
		DrawBillBoard(pItem->pData->v,pItem->pData->s,pItem->pData->r,pItem->pData->a,0.3f);
	}

	glDisable(GL_BLEND);
	glDepthMask(GL_TRUE);
}

bool Smoke::IsAlive()const {return m_fLife>0.0f || m_pSmokePool->IsAllDeleted()==false;}