#ifndef SMOKE_H
#define SMOKE_H

#include "Pool.h"
#include "Types/Vector3D.h"

class CTexture;

class Smoke
{
	struct SSmokeEntity
	{
		Vector3D	v;
		float		a;
		float		s;
		float		r;

		Vector3D	velCof;
		float		rotCof;
		float		alphaCof;

	};
	typedef Pool<SSmokeEntity>	SmokePool;

	CTexture				*m_pSmokeTexture;

	uint					 m_nSmokeCnt;

	SmokePool				*m_pSmokePool;

	float					 m_fLife;

	float					 m_fSmokeSpawn;

	Vector3D				 m_vSmokeCenter;
public:
	Smoke(CTexture *pTexture);
	~Smoke();

	void			Reset(const Vector3D& vSmokeCenter);

	void			Update(float fDeltaTime);

	void			Render();

	bool			IsAlive()const;
};

#endif