#include "Tank.h"
#include "Managers/CModelManager.hpp"
#include "Types/Math1D.h"
#include "Utils/CKeys.h"

#include "ErrorCheck.h"

Tank::Tank(CModel* pModel):CRenderObject(pModel)
{
	m_fSideRotation = 0.0f;
	m_fUpRotation	= 0;

	m_pCannon = new CRenderObject(g_pcModelMan->GetModel("Cannon.tct"));
	m_mCannonRot = Matrix3D::getIdentityMatrix();

	m_fTargetSideRotation = 0.0f;
	m_fTargetUpRotation= 0.0f;
	m_fInterpolation = 0.0f;

	m_fSrcSideRotation= 0.0f;
	m_fSrcUpRotation= 0.0f;
}
Tank::~Tank()
{
	delete m_pCannon;
}

void Tank::CalcRotation()
{
	Vector3D vLook = GetPosition();vLook.normalize();
	Vector3D vUp(0,0,1);
	Vector3D vRight= Cross(vUp,vLook);vRight.normalize();
	vUp			   = Cross(vLook,vRight);vUp.normalize();

	Matrix3D mm = Matrix3D::getIdentityMatrix();
	mm[0][0] = vLook.x;	mm[1][0] = vLook.y;	mm[2][0] = vLook.z;
	mm[0][1] = vRight.x;mm[1][1] = vRight.y;mm[2][1] = vRight.z;
	mm[0][2] = vUp.x;	mm[1][2] = vUp.y;	mm[2][2] = vUp.z;

	Matrix3D sideRot = Matrix3D::getRotateZMatrix(m_fSideRotation);
	Matrix3D upRot = Matrix3D::getRotateXMatrix(m_fUpRotation);


	Matrix3D m,rot = Matrix3D::getRotateYMatrix(-PI/2);
	m = mm*rot*sideRot;

	m_mCannonRot = mm*rot*sideRot*upRot;
	m_pCannon->SetRotation(m_mCannonRot);

	Vector3D vOffsetY(0,0,6);
	Vector3D vOffsetX(1.0f,0,0);
	vOffsetY=m*vOffsetY;
	vOffsetX=m*vOffsetX;
	m_pCannon->SetPosition(GetPosition()+vOffsetY+vOffsetX);

	SetRotation(m);
}
void Tank::Update(float fDeltaTime)
{
	if(g_cKeys.GetKey(VK_LEFT))
	{
		m_fSideRotation = fWrap( m_fSideRotation-fDeltaTime,TWO_PI);
	}
	if(g_cKeys.GetKey(VK_RIGHT))
	{
		m_fSideRotation = fWrap( fDeltaTime+m_fSideRotation,TWO_PI);
	}
	if(g_cKeys.GetKey(VK_UP))
	{
		m_fUpRotation = fClamp( m_fUpRotation-fDeltaTime,-PI,0);
	}
	if(g_cKeys.GetKey(VK_DOWN))
	{
		m_fUpRotation =fClamp( m_fUpRotation+fDeltaTime,-PI,0);
	}
	CalcRotation();
}
void	Tank::DecideMove()
{
	m_fSrcSideRotation    = m_fSideRotation;
	m_fSrcUpRotation    = m_fUpRotation;

	m_fTargetSideRotation = fRandom(TWO_PI);
	float up			  = fRandom(0,PI/4.0f);
	if((rand()&1)==0)
	{
		m_fTargetUpRotation = -PI+up;
	}
	else
	{
		m_fTargetUpRotation = -up;
	}
	m_fInterpolation = 0.0f;
}

void	Tank::UpdateCPU(float fDeltaTime)
{
	m_fInterpolation = fClamp(m_fInterpolation+fDeltaTime,0.0f,2.0f);

	float t1 = fMin(m_fInterpolation,1.0f);
	float t2 = fClamp(m_fInterpolation-1.0f,0.0f,1.0f);

	m_fSideRotation = fLerp(m_fSrcSideRotation,m_fTargetSideRotation,t1);
	m_fUpRotation = fLerp(m_fSrcUpRotation,m_fTargetUpRotation,t2);

	CalcRotation();
}
bool	Tank::CPUWantsToFire()
{
	return (m_fInterpolation>=2.0f);
}
void	Tank::Render()
{
	CRenderObject::Render();
	m_pCannon->Render();
}
