#ifndef TANK_H
#define TANK_H

#include "Models/CRenderObject.hpp"

class Tank:public CRenderObject
{
	float			m_fSideRotation;
	float			m_fUpRotation;
	Matrix3D		m_mCannonRot;

	CRenderObject*	m_pCannon;

	float			m_fSrcSideRotation;
	float			m_fSrcUpRotation;

	float			m_fTargetSideRotation;
	float			m_fTargetUpRotation;
	float			m_fInterpolation;
public:
	Tank(CModel *pModel);
	~Tank();

	void				CalcRotation();

	void				Update(float fDeltaTime);

	//CPU PART

	void				DecideMove();

	void				UpdateCPU(float fDeltaTime);

	bool				CPUWantsToFire();

	void				Render();

	inline	Vector3D	GetCanonPos()const{return m_pCannon->GetPosition();}
	inline	Matrix3D	GetCanonRot()const{return m_pCannon->GetRotation();}
};


#endif
