#include "Trail.h"
#include "Billboard.h"
#include "Texture/CTexture.h"

#include "Types/Math1D.h"
#include "Types/Math3D.h"

#include "ErrorCheck.h"


Trail::Trail(CTexture *pTexture)
{
	m_pTrailTexture = pTexture;
	m_nTrailCnt = 1000;
	m_pTrailPool = TrailPool::Create(m_nTrailCnt);
}
Trail::~Trail()
{
	delete m_pTrailPool;
}

void Trail::UpdateSpawns(float fDeltaTime,const Vector3D& vSpawnPoint)
{
	m_fTrailSpawn-=fDeltaTime;
	//if(m_fTrailSpawn<0.1f)
	{
		m_fTrailSpawn+=0.1f;
		TrailPool::Iterator* pItem = m_pTrailPool->Allocate();
		if(pItem)
		{
			pItem->pData->v = vSpawnPoint;
			pItem->pData->a = 1.0f;
			pItem->pData->s = 0.4f;
			pItem->pData->r = fRandom(PI);
			pItem->pData->velCof   = GetRandomVector();
			pItem->pData->rotCof   = fRandom(4.1f,20.1f);
			pItem->pData->alphaCof = fRandom(0.1f,1.0f);

		}
	}
}
void Trail::Update(float fDeltaTime)
{

	TrailPool::Iterator * pPrevItem = NULL;
	for(TrailPool::Iterator* pItem = m_pTrailPool->Next(NULL);
		pItem!=NULL;
		pItem = m_pTrailPool->Next(pItem))
	{
		Vector3D vDir = pItem->pData->v;
		vDir.normalize(); 
		vDir = (vDir*0.9f+pItem->pData->velCof*0.1f)*3.0f;
		pItem->pData->v+=vDir*fDeltaTime;
		pItem->pData->s+= fDeltaTime*2.0f;
		pItem->pData->r = fWrap(pItem->pData->r+pItem->pData->rotCof*fDeltaTime,TWO_PI);
		pItem->pData->a = fMax(pItem->pData->a-pItem->pData->alphaCof*fDeltaTime*3.0f,0.0f);
		if(pItem->pData->a<=0.0f)
		{
			m_pTrailPool->Delete(pItem);
			pItem = pPrevItem;
		}
		else
		{
			pPrevItem = pItem;
		}
	}

}

void Trail::Render()
{
	glBindTexture(GL_TEXTURE_2D,m_pTrailTexture->GetTextureId());
	glDisable(GL_LIGHTING);
	glEnable(GL_BLEND);
	glDepthMask(GL_FALSE);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);

	for(TrailPool::Iterator* pItem = m_pTrailPool->Next(NULL);
		pItem!=NULL;
		pItem = m_pTrailPool->Next(pItem))
	{
		DrawBillBoard(pItem->pData->v,pItem->pData->s,pItem->pData->r,pItem->pData->a,0.7f);
	}

	glDisable(GL_BLEND);
	glDepthMask(GL_TRUE);
}
