#ifndef TRAIL_H
#define TRAIL_H

#include "Pool.h"
#include "Types/Vector3D.h"

class CTexture;

class Trail
{
	struct STrailEntity
	{
		Vector3D	v;
		float		a;
		float		s;
		float		r;

		Vector3D	velCof;
		float		rotCof;
		float		alphaCof;

	};
	typedef Pool<STrailEntity>	TrailPool;

	CTexture				*m_pTrailTexture;

	uint					 m_nTrailCnt;

	TrailPool				*m_pTrailPool;

	float					 m_fTrailSpawn;

public:
	Trail(CTexture *pTexture);
	~Trail();

	void			UpdateSpawns(float fDeltaTime,const Vector3D& vSpawnPoint);

	void			Update(float fDeltaTime);

	void			Render();

};

#endif