#include "stdafx.h"
#include "ErrorCheck.h"



char *g_szFatalErrorFile=NULL;
int   g_nFatalErrorLine=NULL;
char *g_szFatalErrorFunc=NULL;


void FatalErrorV(const char *fmt, va_list ap,bool bStopProgram=true) 
{
	char *file = g_szFatalErrorFile;
    int   line = g_nFatalErrorLine;
    char *func = g_szFatalErrorFunc;

    char strings[0x1000];
    char szErrorMsg[0x1000];
    vsprintf(strings, fmt, ap);
    sprintf(szErrorMsg,"%s(%d):%s()  %s",file,line,func,strings);
    if(bStopProgram)MessageBox(NULL,szErrorMsg,"Caught Error",MB_OK);
	else bStopProgram = MessageBox(NULL,szErrorMsg,"Caught Error",MB_RETRYCANCEL)==IDCANCEL;
    
    if(bStopProgram)
    {
		__asm{ int 3 };
	}

}
void FatalError(const char *fmt, ...) {
	if(fmt==NULL)return;
    va_list ap;
    va_start(ap, fmt);
    FatalErrorV(fmt, ap);
    va_end(ap);
}


void DebugMessage(const char *fmt , ...)
{
	if(fmt==NULL)return;
    va_list ap;
    va_start(ap, fmt);
    FatalErrorV(fmt, ap,false);
    va_end(ap);
}







// Error Strings
char* aGLSLErrorString[] = {
	"(e0000) GLSL not enabled",
		"(e0001) not a valid program object",
		"(e0002) not a valid object",
		"(e0003) out of memory",
		"(e0004) unknown compiler error"};
	//-----------------------------------------------------------------------------      


int CheckGLError(char *file, int line)
{
	GLenum glErr;
	int    retCode = 0;

	glErr = glGetError();
	//FIX ME
	
	while (glErr != GL_NO_ERROR) {
		FATALERROR( "GL Error #%d (%s) in File %s at line: %d\n" ,glErr , gluErrorString(glErr) ,file , line );
		retCode = 1;
		glErr = glGetError();


	}
	return retCode;
}
int CheckDIError(char *file, int line)
{
	ILenum ilErr;
	int    retCode = 0;

	ilErr = ilGetError();
	//FIX ME

	while (ilErr != IL_NO_ERROR)
	{
		FATALERROR( "IL Error #%d (%s) in File %s at line: %d\n" ,ilErr , iluErrorString(ilErr) ,file , line );
		retCode = 1;
		ilErr = ilGetError();
	}
	return retCode;
}


