#include "Globals/Globals.hpp"
#include "Platform/Cpu.h"
#include "Opengl/OpenGLExtensions.h"
#include "AppUtils/AppSettings.hpp"
#include "Props/CProperties.hpp"

#include "ErrorCheck.h"


SApplicationValues g_sApp;
float			   g_fTime;
float		       g_fFrameTime;
unsigned int	   g_nFrameCount;
float			   g_nUpdateTime;
unsigned int	   g_nUpdateRepeatCount;
CProperties		  *g_pcAppProps = NULL;
bool				g_bGLSL_Supported=false;

namespace ShaderVals
{
	float		g_fShTime		= 0.0f;		
	float		g_fShLoopTime   = 0.0f;
	float		g_fShHillTime   = 0.0f;
	float		g_fShSinus		= 0.0f;
	float		g_fShCosinus	= 0.0f;
	float		g_fShHillCof	= 1.0f;
	Vector3D    g_vEye			= Vector3D(0,0,0);
	Vector3D	g_vCurPosition		= Vector3D(0,0,0);
	Vector3D	 g_vCurScale		= Vector3D(0,0,0);
	Matrix3D	 g_mCurRotation;
};

bool	AppInit()
{
	GetModuleFileName(NULL,g_sApp.strMainDir,512);
	int nCurPlace=int(strlen(g_sApp.strMainDir))-1;
	
	ASSERT(nCurPlace<512,"This shouldnt happen , Directory is too long");
	while(g_sApp.strMainDir[nCurPlace]!='\\')nCurPlace--;
	g_sApp.strMainDir[nCurPlace+1]='\0';

	g_pcAppProps = new CProperties();
	//InitSettings();

	LoadSettings("Data\\config.xml");
	

	g_bGLSL_Supported=false;
	g_fTime=0.0f;
	g_fFrameTime=0.0f;
	g_nFrameCount=0;
	
	//Initial Application Settings
	g_sApp.bActive=false;
	g_sApp.bFullScreen=false;
	g_sApp.hDC=NULL;
	g_sApp.hInstance=NULL;
	g_sApp.hRC=NULL;
	g_sApp.hWnd=NULL;
	
	//Get Information About CPU
	initCPU();
	
	g_bGLSL_Supported=false;
	
	
	//Get Main Directory
	

	
	

	g_sApp.eAppType=PT_NORMAL;
	
	return true;
	
}

void	AppDeInit()
{
	SaveSettings("Data\\config.xml");
	delete g_pcAppProps;
}