#include "OpenGLWnd.h"
#include "Globals/Globals.hpp"
#include "LoggerDlg.h"
#include "CMsgProcessor.hpp"
#include "CrashRpt.h"

#include "Props/CAttribute.hpp"
#include "Props/CAttributeGroup.hpp"
#include "Props/CProperties.hpp"

#include "ErrorCheck.h"


OpenGLWnd *pcApp=NULL;

LRESULT CALLBACK WndProc(	HWND	hWnd,			// Pointeris i musu langa
							UINT	uMsg,			// Lango zinutes
							WPARAM	wParam,			
							LPARAM	lParam)		
{
	int wmId ,wmEvent;
	switch (uMsg)									// Tikriname zinuter
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:

			if(!pcApp->ProcessMenu(wmId,wmEvent))
				return DefWindowProc(hWnd, uMsg, wParam, lParam);
			break;

		case WM_ACTIVATE:							// Jeigu buvo aktivuotas langas
		{
			if (!HIWORD(wParam))					// Ar buvo minimizuotas
			{
				g_sApp.bActive=TRUE;					// Programa yra aktyvi
			}
			else
			{
				g_sApp.bActive=FALSE;					// Programa neaktyvi
			}

			return 0;								// Grizti i zinuciu cikla
		}

		case WM_SYSCOMMAND:							// Systemines komandos
		{
			switch (wParam)							
			{
				case SC_SCREENSAVE:					// Screensaveris 
				case SC_MONITORPOWER:				// Monitorius bando issijungti
				return 0;							// To daryti neleidziame
			}
			break;									// Exit
		}

		case WM_CLOSE:								// Ar gavome zinute ,apie programos pabaiga
		{
			PostQuitMessage(0);						// Siunciame "Quit Message"
			return 0;								
		}

		case WM_CHAR:
		{
			pcApp->m_pcMsgProcessor->OnChar(BYTE(wParam),BYTE(lParam));
			return 0;		
		}
		case WM_KEYDOWN:							// Ar paspaustas klavisas
		{
			pcApp->m_pcMsgProcessor->OnKeyDown(BYTE(wParam),BYTE(lParam));
			return 0;								
		}

		case WM_KEYUP:								// Ar klavisas buvo paleistas
		{
			pcApp->m_pcMsgProcessor->OnKeyUp(BYTE(wParam),BYTE(lParam));
			return 0;								
		}
		case WM_LBUTTONDOWN:
		{
			pcApp->m_pcMsgProcessor->OnLButtonDown();
			return 0;
		}
		case WM_LBUTTONUP:
		{
			pcApp->m_pcMsgProcessor->OnLButtonUp();
			return 0;
		}
		case WM_LBUTTONDBLCLK:
		{
			return 0;
		}
		case WM_RBUTTONDOWN:
		{
			pcApp->m_pcMsgProcessor->OnRButtonDown();
			return 0;
		}
		case WM_RBUTTONUP:
		{
			pcApp->m_pcMsgProcessor->OnRButtonUp();
			return 0;
		}
		case WM_RBUTTONDBLCLK:
		{
			return 0;
		}
		case WM_MOUSEMOVE:
		{
			pcApp->m_pcMsgProcessor->OnMouseMove(LOWORD(lParam),HIWORD(lParam));
			return 0;
		}

		case WM_SIZE:								// Koreguojame lango dydi
		{	
			g_nWd=LOWORD(lParam);
			g_nHt=HIWORD(lParam);
			pcApp->m_pcMsgProcessor->OnResize(g_nWd,g_nHt);
			pcApp->ReSizeGLScene();  
			return 0;											 
		}
	}

	// Tai ka praleidome , sutvarkys windows
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}


BOOL WINAPI CrashCallback(LPVOID lpvState)
{
   //AddFile(lpvState, "dummy.log", "Dummy Log File");
   //AddFile(lpvState, "dummy.ini", "Dummy INI File");

   return TRUE;
}

int FrameWorkInit( OpenGLWnd   *_pcApp,
				   HINSTANCE	hInstance,			
				   HINSTANCE	hPrevInstance,		
				   LPSTR		lpCmdLine,			
				   int			nCmdShow)			
{

#ifdef _DEBUG
	//LPVOID nCrashRptState=Install(CrashCallback, "tomdir@gmail.com", "Terrain Editor crashed");
#endif

	if (!AppInit())
	{
		FATALERROR("AppInit() return false. How could it be?");
		return -1;
	}

	//Create Application
	pcApp= _pcApp;

	//Create our window


	if (!pcApp->CreateGLWindow(
		g_pcAppProps->FindAttrGroup("Window")->FindAttribute("sName")->GetString(),
		g_pcAppProps->FindAttrGroup("Window")->FindAttribute("iWidth")->GetInt(),
		g_pcAppProps->FindAttrGroup("Window")->FindAttribute("iHeight")->GetInt(),
		g_pcAppProps->FindAttrGroup("Window")->FindAttribute("iBits")->GetInt(),
		g_pcAppProps->FindAttrGroup("Window")->FindAttribute("bFullscreen")->GetBool(),
		hInstance,WndProc))
	{
		pcApp->DestroyGLWindow();		
		delete pcApp;						
		return -1;
	}
	//Extensions
	if(!pcApp->InitExtensions())
	{
		pcApp->DestroyGLWindow();		
		delete pcApp;							
		return -1;
	}
	pcApp->LoadSettings();

	if(!pcApp->LoadResources())
	{
		pcApp->DestroyGLWindow();
		delete pcApp;	
		return -1;
	}

	if(!pcApp->InitGL())
	{
		pcApp->DeInitGL();
		pcApp->UnLoadResources();
		pcApp->DestroyGLWindow();
		delete pcApp;		
		return -1;
	}

	

	//We made it here, so show our window
	ShowWindow(g_sApp.hWnd,SW_SHOW);						// Show The Window
	SetForegroundWindow(g_sApp.hWnd);						// Slightly Higher Priority
	SetFocus(g_sApp.hWnd);									// Sets Keyboard Focus To The Window
	pcApp->ReSizeGLScene();										// Set Up Our Perspective GL Screen


	MSG		msg;	

	while( pcApp->IfRunning())									// Ciklas ,kol pasibaigs programa=FALSE
	{
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))			// Ar yra kokios zinutes?
		{
			if (msg.message==WM_QUIT )						// Ar yra "quit" zinute?
			{
				pcApp->End();
			}
			else										// Jei ne ,tai pereiname prie kitu zinute
			{
				TranslateMessage(&msg);						// Konvertuojame zinute i mums aiskia forma
				DispatchMessage(&msg);						
			}
		}
		else												// Jei nera jokiu zinuciu ,paisome langa
		{
			//m_timer.Update();
			pcApp->Loop();

		}
	}

	// Shutdown'as
	pcApp->SaveSettings();
	pcApp->DeInitGL();
	pcApp->UnLoadResources();
	pcApp->DestroyGLWindow();									// Naikiname langa

	delete pcApp;	

	while(g_cLogger.IfRunning())
	{
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))			// Ar yra kokios zinutes?
		{
			if (msg.message==WM_QUIT )						// Ar yra "quit" zinute?
			{

			}
			else										// Jei ne ,tai pereiname prie kitu zinute
			{
				TranslateMessage(&msg);						// Konvertuojame zinute i mums aiskia forma
				DispatchMessage(&msg);						
			}
		}

	}
	AppDeInit();


#ifdef _DEBUG
//	Uninstall(nCrashRptState);
#endif
#if defined(_DEBUG) && !defined(DISABLE_MEMORY_MAN)
	m_dumpMemoryReport();
#endif
	return int(msg.wParam);										// Iseiti is Programos
}


