#include "OpenGLWnd.h"
#include "Lights/DefaultLight.hpp"
#include "Utils/CKeys.h"
#include "Utils/CMouseState.h"
#include "CMsgProcessor.hpp"
#include "Camera/Camera.h"
//Globals
#include "Globals/Globals.hpp"
//Extensions
#include "Opengl/OpenGLExtensions.h"
//Debug
#include "ErrorCheck.h"

OpenGLWnd::OpenGLWnd(CMessageProc *pcMsgProc)
:m_pcMsgProcessor(pcMsgProc)
{
	m_bRunning=true;
	m_fCurFPS=0.0f;
}
OpenGLWnd::~OpenGLWnd()
{
	delete m_pcMsgProcessor;
}

BOOL	OpenGLWnd::CreateGLWindow(const char* title, int width, int height, int bits,bool _bFullScreen,HINSTANCE hInstance,WNDPROC fnWndProc){				
	GLuint		PixelFormat;			// Holds The Results After Searching For A Match
	WNDCLASS	wc;						// Windows Class Structure
	DWORD		dwExStyle;				// Window Extended Style
	DWORD		dwStyle;				// Window Style
	RECT		WindowRect;				// Grabs Rectangle Upper Left / Lower Right Values
	WindowRect.left=(long)0;			// Set Left Value To 0
	WindowRect.right=(long)width;		// Set Right Value To Requested Width
	WindowRect.top=(long)0;				// Set Top Value To 0
	WindowRect.bottom=(long)height;		// Set Bottom Value To Requested Height


	g_sApp.bFullScreen=_bFullScreen;


	///////////////////
	wc.style			= CS_HREDRAW | CS_VREDRAW | CS_OWNDC;	// Redraw On Size, And Own DC For Window.
	wc.lpfnWndProc		= (WNDPROC) fnWndProc;					// WndProc Handles Messages
	wc.cbClsExtra		= 0;									// No Extra Window Data
	wc.cbWndExtra		= 0;									// No Extra Window Data
	wc.hInstance		= hInstance;							// Set The Instance
	wc.hIcon			= LoadIcon(NULL, IDI_WINLOGO);			// Load The Default Icon
	wc.hCursor			= LoadCursor(NULL, IDC_ARROW);			// Load The Arrow Pointer
	wc.hbrBackground	= NULL;									// No Background Required For GL
	wc.lpszMenuName		=  NULL;//MAKEINTRESOURCE(IDR_MAINMENU);									// We Don't Want A Menu
	wc.lpszClassName	= "OpenGL";								// Set The Class Name



	//REQUIRED FOR FONT
	g_nWd=width;
	g_nHt=height-((wc.lpszMenuName==NULL)?0:GetSystemMetrics(SM_CYMENU));
	g_nhWd=g_nWd/2;
	g_nhHt=g_nHt/2;

	g_nCenterX=g_nhWd;
	g_nCenterY=g_nhHt;

	if (!RegisterClass(&wc))									// Attempt To Register The Window Class
	{
		MessageBox(NULL,"Failed To Register The Window Class.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;											// Return FALSE
	}
	
	if (g_sApp.bFullScreen)												// Attempt Fullscreen Mode?
	{
		DEVMODE dmScreenSettings;								// Device Mode
		memset(&dmScreenSettings,0,sizeof(dmScreenSettings));	// Makes Sure Memory's Cleared
		dmScreenSettings.dmSize=sizeof(dmScreenSettings);		// Size Of The Devmode Structure
		dmScreenSettings.dmPelsWidth	= width;				// Selected Screen Width
		dmScreenSettings.dmPelsHeight	= height;				// Selected Screen Height
		dmScreenSettings.dmBitsPerPel	= bits;					// Selected Bits Per Pixel
		dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;

		// Try To Set Selected Mode And Get Results.  NOTE: CDS_FULLSCREEN Gets Rid Of Start Bar.
		if (ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL)
		{
			// If The Mode Fails, Offer Two Options.  Quit Or Use Windowed Mode.
			if (MessageBox(NULL,"The Requested Fullscreen Mode Is Not Supported By\nYour Video Card. Use Windowed Mode Instead?","NeHe GL",MB_YESNO|MB_ICONEXCLAMATION)==IDYES)
			{
				g_sApp.bFullScreen=FALSE;		// Windowed Mode Selected.  Fullscreen = FALSE
			}
			else
			{
				// Pop Up A Message Box Letting User Know The Program Is Closing.
				MessageBox(NULL,"Program Will Now Close.","ERROR",MB_OK|MB_ICONSTOP);
				return FALSE;									// Return FALSE
			}
		}
	}

	if (g_sApp.bFullScreen)												// Are We Still In Fullscreen Mode?
	{
		dwExStyle=WS_EX_APPWINDOW;								// Window Extended Style
		dwStyle=WS_POPUP;										// Windows Style
	//	ShowCursor(FALSE);										// Hide Mouse Pointer
	}
	else
	{
		dwExStyle=WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;			// Window Extended Style
		dwStyle=WS_OVERLAPPEDWINDOW;							// Windows Style
	}

	AdjustWindowRectEx(&WindowRect, dwStyle, FALSE, dwExStyle);		// Adjust Window To True Requested Size

	// Create The Window
	if (!(g_sApp.hWnd=CreateWindowEx(	dwExStyle,							// Extended Style For The Window
								"OpenGL",							// Class Name
								title,								// Window Title
								dwStyle |							// Defined Window Style
								WS_CLIPSIBLINGS |					// Required Window Style
								WS_CLIPCHILDREN,					// Required Window Style
								0, 0,								// Window Position
								WindowRect.right-WindowRect.left,	// Calculate Window Width
								WindowRect.bottom-WindowRect.top,	// Calculate Window Height
								NULL,								// No Parent Window
								NULL,								// No Menu
								hInstance,							// Instance
								NULL)))								// Dont Pass Anything To WM_CREATE
	{
		DestroyGLWindow();								// Reset The Display
		MessageBox(NULL,"Window Creation Error.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	static	PIXELFORMATDESCRIPTOR pfd=				// pfd Tells Windows How We Want Things To Be
	{
		sizeof(PIXELFORMATDESCRIPTOR),				// Size Of This Pixel Format Descriptor
		1,											// Version Number
		PFD_DRAW_TO_WINDOW |						// Format Must Support Window
		PFD_SUPPORT_OPENGL |						// Format Must Support OpenGL
		PFD_DOUBLEBUFFER,							// Must Support Double Buffering
		PFD_TYPE_RGBA,								// Request An RGBA Format
		bits,										// Select Our Color Depth
		0, 0, 0, 0, 0, 0,							// Color Bits Ignored
		1,											// Alpha Buffer Must Be on 
		0,											// Shift Bit Ignored
		0,											// No Accumulation Buffer
		0, 0, 0, 0,									// Accumulation Bits Ignored
		16,											// 16Bit Z-Buffer (Depth Buffer)  
		0,											// No Stencil Buffer
		0,											// No Auxiliary Buffer
		PFD_MAIN_PLANE,								// Main Drawing Layer
		0,											// Reserved
		0, 0, 0										// Layer Masks Ignored
	};
	
	if (!(g_sApp.hDC=GetDC(g_sApp.hWnd)))							// Did We Get A Device Context?
	{
		DestroyGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Create A GL Device Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if (!(PixelFormat=ChoosePixelFormat(g_sApp.hDC,&pfd)))	// Did Windows Find A Matching Pixel Format?
	{
		DestroyGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Find A Suitable PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if(!SetPixelFormat(g_sApp.hDC,PixelFormat,&pfd))		// Are We Able To Set The Pixel Format?
	{
		DestroyGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Set The PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if (!(g_sApp.hRC=wglCreateContext(g_sApp.hDC)))				// Are We Able To Get A Rendering Context?
	{
		DestroyGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Create A GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if(!wglMakeCurrent(g_sApp.hDC,g_sApp.hRC))					// Try To Activate The Rendering Context
	{
		DestroyGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Activate The GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}


	return TRUE;
}
void	OpenGLWnd::DestroyGLWindow()
{
	if (g_sApp.bFullScreen)										// Are We In Fullscreen Mode?
	{
		ChangeDisplaySettings(NULL,0);					// If So Switch Back To The Desktop
		ShowCursor(TRUE);								// Show Mouse Pointer
	}

	if (g_sApp.hRC)											// Do We Have A Rendering Context?
	{
		if (!wglMakeCurrent(NULL,NULL))					// Are We Able To Release The DC And RC Contexts?
		{
			MessageBox(NULL,"Release Of DC And RC Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		}

		if (!wglDeleteContext(g_sApp.hRC))						// Are We Able To Delete The RC?
		{
			MessageBox(NULL,"Release Rendering Context Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		}
		g_sApp.hRC=NULL;										// Set RC To NULL
	}

	if (g_sApp.hDC && !ReleaseDC(g_sApp.hWnd,g_sApp.hDC))					// Are We Able To Release The DC
	{
		MessageBox(NULL,"Release Device Context Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		g_sApp.hDC=NULL;										// Set DC To NULL
	}

	if (g_sApp.hWnd && !DestroyWindow(g_sApp.hWnd))					// Are We Able To Destroy The Window?
	{
		MessageBox(NULL,"Could Not Release hWnd.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		g_sApp.hWnd=NULL;										// Set hWnd To NULL
	}

	if (!UnregisterClass("OpenGL",g_sApp.hInstance))			// Are We Able To Unregister Class
	{
		MessageBox(NULL,"Could Not Unregister Class.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		g_sApp.hInstance=NULL;									// Set hInstance To NULL
	}
}
void	OpenGLWnd::ReSizeGLScene()		// Resize And Initialize The GL Window
{
	if (g_nViewportHt==0)										// Prevent A Divide By Zero By
	{
		g_nViewportHt=1;										// Making Height Equal One
	}

	//g_nWd=g_nHt=512;
	glViewport(0,0,g_nWd,g_nHt);						// Reset The Current Viewport

	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glLoadIdentity();									// Reset The Projection Matrix

	// Calculate The Aspect Ratio Of The Window
	gluPerspective(45.0f,((GLfloat)g_nWd/(GLfloat)g_nHt),0.1f,13000.0f);

	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	glLoadIdentity();									// Reset The Modelview Matrix
}

bool	OpenGLWnd::InitManagers()
{	
	return true;
}
void	OpenGLWnd::DeInitManagers()
{
}
bool	OpenGLWnd::LoadResources()
{
	if(!InitManagers())return false;
	return true;
}
void	OpenGLWnd::UnLoadResources()
{
	DeInitManagers();
}
bool	OpenGLWnd::InitExtensions()
{
	initExtensions(g_sApp.hDC);
	//GLSL support
	if (!GL_ARB_shader_objects_supported)
	{
		FATALERROR( "**warning** GL_ARB_shader_objects not defined!!\n"); 
		return false;
	}
	if (!GL_ARB_vertex_shader_supported)
	{
		FATALERROR( "**warning** GL_ARB_vertex_shader not defined!!\n");
		return false;
	}
	if (!GL_ARB_fragment_shader_supported)
	{
		FATALERROR( "**warning** GL_ARB_fragment_shader not defined!!\n");
		return false;
	}

	if (!GL_ARB_shading_language_100_supported)
	{
		FATALERROR( "**warning** GL_ARB_shading_language_100 not defined!!\n");
		return false;
	}
	g_bGLSL_Supported=true;
	return true;
}
bool	OpenGLWnd::InitGL()										// All Setup For OpenGL Goes Here
{
	//glEnable(GL_TEXTURE_2D);
	glClearColor(0.5f, 0.5f,1.0f , 0.0f);				// Black Background
	glClearDepth(1.0f);									// Depth Buffer Setup
	glEnable(GL_DEPTH_TEST);							// Enables Depth Testing
	glShadeModel(GL_SMOOTH);

	glDepthFunc(GL_LEQUAL);								// The Type Of Depth Testing To Do
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	// Really Nice Perspective Calculations
	glEnable(GL_TEXTURE_2D);

	glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);

	DefaultLighting();

	

	return true;
}

void	OpenGLWnd::DeInitGL()
{

}
void	OpenGLWnd::LoadSettings()
{

}
void	OpenGLWnd::SaveSettings()
{

}

void	OpenGLWnd::Loop()
{
	static DWORD nLastTick=GetTickCount();
	DWORD		 nCurTick=GetTickCount();
	static float fFixedTime = 0.0f;
	const  float fTimeStep  = 0.01f;
	
	static int	 nLagCount  = 0;

	if (g_sApp.bActive)
	{	
		if (g_cKeys.GetKey(VK_ESCAPE))				
		{
			End();						
		}
		else								
		{
			//Update Time
			g_fFrameTime=float(nCurTick-nLastTick)/1000.0f;
			g_fTime+=g_fFrameTime;

			//Lag prevention
			//The story goes this way:
			//suppose g_nFrameTime 0.05f so we must make 5 updates, but
			//those 5 update takes 0.07f time, so next frame we must make 5 updates again and again..
			//So sometimes we skip an update to make application not laggy
			
			if(g_fFrameTime>0.05f)
			{
				g_fFrameTime=0.05f;
				nLagCount++;
			}	
			nLastTick=nCurTick;
			g_nFrameCount++;
			
			
			if(nLagCount<10)
			{
				fFixedTime+=g_fFrameTime;
	     		g_nUpdateRepeatCount=0;
	     		CheckInput();
				while(fFixedTime>fTimeStep)
				{
					
					Update(fTimeStep);
					fFixedTime-=fTimeStep;
					g_nUpdateRepeatCount++;
					
					//To prevent key change
					//(fFixedTime>fTimeStep)g_cKeys.Update();
					if(g_nUpdateRepeatCount==1)g_cKeys.Update();
				}
				g_nUpdateTime=float(GetTickCount()-nCurTick)/1000.0f;
			}
			else
			{
				//We had a lag checkpoint
				fFixedTime=0.0f;
				nLagCount=0;
			}

			DrawGLScene();		
				
			
			g_cMouse.Update();
			
			SwapBuffers(g_sApp.hDC);			
		}
	}
	else
	{
		Sleep(1000);
	}
}
void	OpenGLWnd::DrawGLScene(GLvoid)
{
#ifdef CALC_REND_TRIS
	g_nVertRendered=0;
#endif


	static float fLastFPS=0;
	static DWORD lastime=GetTickCount();;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT /*| GL_STENCIL_BUFFER_BIT*/ );	// Clear Screen And Depth Buffer
	fLastFPS++;
	if(GetTickCount()-lastime>1000)
	{
		m_fCurFPS=fLastFPS;
		fLastFPS=0;
		lastime=GetTickCount();
	}

	PreRender();

	//RenderStaticScene();

	//RenderDynamicScene();

	PostRender();
}


void	OpenGLWnd::PreRender()
{
}
void	OpenGLWnd::RenderStaticScene()
{
}
void	OpenGLWnd::RenderDynamicScene()
{
}
void	OpenGLWnd::PostRender()
{
}
void	OpenGLWnd::CheckInput()
{
}
void	OpenGLWnd::Update(float fDeltaTime)
{
	ShaderVals::g_fShTime		+= fDeltaTime;	

	ShaderVals::g_fShSinus		= sinf(ShaderVals::g_fShTime);
	ShaderVals::g_fShCosinus	= cosf(ShaderVals::g_fShTime);
	ShaderVals::g_fShLoopTime	 = fmodf(ShaderVals::g_fShLoopTime+fDeltaTime,1.0f);
	ShaderVals::g_fShHillTime	+= fDeltaTime*ShaderVals::g_fShHillCof;
	if(ShaderVals::g_fShHillTime>1.0f && ShaderVals::g_fShHillCof>0.0f)
	{
		ShaderVals::g_fShHillTime = 2.0f - ShaderVals::g_fShHillTime;
		ShaderVals::g_fShHillCof  = - ShaderVals::g_fShHillCof;
	}
	if(ShaderVals::g_fShHillTime<0.0f && ShaderVals::g_fShHillCof<0.0f)
	{
		ShaderVals::g_fShHillTime = - ShaderVals::g_fShHillTime;
		ShaderVals::g_fShHillCof  = - ShaderVals::g_fShHillCof;
	}
	ShaderVals::g_vEye = g_cMainCam.GetEye();
}
void	OpenGLWnd::SetMenuValues()
{
}
bool	OpenGLWnd::ProcessMenu(int wmId ,int wmEvent)
{
	return false;
}