#include "Managers/CAnimationManager.hpp"
#include "Globals/Globals.hpp"
#include "Utils/CFileReader.hpp"
#include "Animations/CSubAnim.hpp"
#include "Animations/CAnimation.hpp"

#include "Types/Vector3D.h"
#include "Types/Quaternion.h"

#include "ErrorCheck.h"

CAnimationManager * g_pcAnimMan = NULL;

CAnimationManager::CAnimationManager()
{
}

CAnimationManager::~CAnimationManager()
{
	m_cItems.ClearData();
	m_cItems.Clear();
}
bool	InvertQuaternion(const Quaternion& qCur ,const Quaternion& qLast)
{
	Quaternion qInv = -qCur;
	float fLen0 = qCur.x*qLast.x + qCur.y*qLast.y + qCur.z*qLast.z;
	float fLen1 = qInv.x*qLast.x + qInv.y*qLast.y + qInv.z*qLast.z;
	return fLen1>fLen0;
}

CAnimation  *CAnimationManager::LoadAnimFile(const char *strFileName)
{
	unsigned int i,k,nNodeCnt,nAnimLen,nAnimValue;

	CAnimEntity  cEntity;
	CSubAnim	*pcNewSub;
	CAnimation	*pcNewAnim;
	char		strName[50];

	CFileReader cBuf;
	if(cBuf.OpenFile(strFileName))
	{
		char strString[5];
		cBuf.ReadString(strString,5);

		ASSERT(strcmp(strString,"ANIM")==0 , "This is not an animation file:%s",strFileName);
		
		//Create new animation class
		pcNewAnim = new CAnimation();
		//Read for how many nodes animation exists
		nNodeCnt = cBuf.ReadUint32();
		//This will be our temporary storage for animation ref
		//Each sub-animation may have parent sub-animation
		//This way we could do hierarchy animations
		//(Not used)
		unsigned *pnAnimRefs = new unsigned[nNodeCnt];

		for(i = 0 ; i<nNodeCnt ; i++)
		{
			//Read node name
			cBuf.ReadString(strName,50);

			Vector3D	vInitialPos;
			Vector3D	vInitialScale;
			Quaternion  qInitialRot;
			BOOL		bHasPosAnim,bHasScaleAnim,bHasRotAnim;

			//Read initial values (of 0 frame)
			vInitialPos   = cBuf.ReadVector3D();
			vInitialScale = cBuf.ReadVector3D();
			qInitialRot   = cBuf.ReadQuaternion();

			//Read which animations are available
			bHasPosAnim = cBuf.ReadInt8();
			bHasScaleAnim = cBuf.ReadInt8();
			bHasRotAnim = cBuf.ReadInt8();

			//Read reference value (-1 stands for no parent)
			pnAnimRefs[i] = cBuf.ReadUint32();
			nAnimLen      = cBuf.ReadInt32();
			//If animation consist of more than 0 frames, load it
			if(nAnimLen>0)
			{
				pcNewSub = new CSubAnim(strName);
				pcNewSub->SetPositionAnim(bHasPosAnim==TRUE);
				pcNewSub->SetScaleAnim(bHasScaleAnim==TRUE);
				pcNewSub->SetRotAnim(bHasRotAnim==TRUE);
				//Set up initial values
				pcNewSub->m_cInitialAnim.m_fAnimValue = 0.0f;
				pcNewSub->m_cInitialAnim.m_vPosition  = vInitialPos;
				pcNewSub->m_cInitialAnim.m_vScale  = vInitialScale;
				pcNewSub->m_cInitialAnim.m_qRot  = qInitialRot;

				//Start reading animation values
				pcNewSub->Begin();
				float x,y,z;
				float fAnimLength = float(nAnimLen)*160.0f;

				for(k=0;k<nAnimLen;k++)
				{
					//Read frame value
					nAnimValue = cBuf.ReadUint32();
					cEntity.m_fAnimValue = float(nAnimValue)/fAnimLength;
					//Read position
					if(bHasPosAnim==TRUE)
					{
						cEntity.m_vPosition = cBuf.ReadVector3D();
						x = cEntity.m_vPosition.x;
						y = cEntity.m_vPosition.y;
						z = cEntity.m_vPosition.z;
						cEntity.m_vPosition =  Vector3D(x,y,z);//Vector3D(-x,z,y)
					}
					else cEntity.m_vPosition = vInitialPos;
					//Read scale
					if(bHasScaleAnim==TRUE)cEntity.m_vScale = cBuf.ReadVector3D();
					else cEntity.m_vScale = vInitialScale;
					//Read rotations
					if(bHasRotAnim==TRUE)cEntity.m_qRot = cBuf.ReadQuaternion();
					else cEntity.m_qRot = qInitialRot;
					//Add sub animation single entity
					pcNewSub->Add(cEntity);
				}
				//Calculate necessary data
				pcNewSub->End();
				//Add animation to our list
				pcNewAnim->AddSubAnimation(pcNewSub);
			}
		}

		//Set up parents
		for(i = 0 ; i<nNodeCnt ; i++)
		{
			if(pnAnimRefs[i]!=-1)
			{
				ASSERT(pnAnimRefs[i]<nNodeCnt,"Ref is out of bounds:%d [0;%d]",pnAnimRefs[i],nNodeCnt);
				pcNewAnim->GetSubAnimByNumber(i)->SetParentAnim(pcNewAnim->GetSubAnimByNumber(pnAnimRefs[i]));
			}
		}
		
		delete []pnAnimRefs;
		cBuf.CloseFile();
		return pcNewAnim;
	}

	return NULL;
}
CAnimation  *CAnimationManager::LoadAnimation(const char *strAnimName)
{
	CAnimation		*pcNewAnim;
	GetFullPath(g_sApp.strMainDir,strAnimName,m_strFullPath);
	if(FindItem(m_strFullPath,pcNewAnim))
	{
		return pcNewAnim;
	}
	else
	{	
		pcNewAnim = LoadAnimFile(m_strFullPath);
		ASSERT(pcNewAnim,"Failed to load animation :%s",m_strFullPath);
		AddItem(m_strFullPath,pcNewAnim);
		return pcNewAnim;
	}
}