#include "Managers/CFXManager.hpp"
#include "Managers/CTextureManager.hpp"

#include "ErrorCheck.h"

CFXManager *g_pcFXMan=NULL;

CFXManager::CFXManager()
{
	
}
CFXManager::~CFXManager()
{

}

void	CFXManager::Init()
{
	m_bFirsTime=true;
	m_pcFXTex=g_pcTexMan->CreateTexture("FXTexture0",g_nViewportWd,g_nViewportHt);
}

void	CFXManager::BeginSequence()
{
	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_ALPHA_TEST);
	glEnable(GL_TEXTURE_2D);

	//	glClear(GL_COLOR_BUFFER_BIT);
	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glPushMatrix();										// Store The Projection Matrix
	glLoadIdentity();									// Reset The Projection Matrix
	glOrtho(0,g_nWd,0,g_nHt,-1,1);							// Set Up An Ortho Screen

	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	glPushMatrix();										// Store The Modelview Matrix
	glLoadIdentity();									// Reset The Modelview Matrix
	glBindTexture(GL_TEXTURE_2D,m_pcFXTex->GetTextureId());
}
void	CFXManager::EndSequence()
{
	m_bFirsTime=false;

	glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 0, 0, m_pcFXTex->GetWidth(), m_pcFXTex->GetHeight(), 0);


	glColor4f(1.0f,1.0f,1.0f,1.0f);
	glViewport(0,0,g_nWd,g_nHt);
	glBegin(GL_QUADS);
	glTexCoord2f(0.0f,0.0f);glVertex2i(0,0);
	glTexCoord2f(1.0f,0.0f);glVertex2i(g_nWd,0);
	glTexCoord2f(1.0f,1.0f);glVertex2i(g_nWd,g_nHt);
	glTexCoord2f(0.0f,1.0f);glVertex2i(0,g_nHt);
	
	
	glEnd();




	glPopMatrix();
	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix		
	glPopMatrix();// Restore The Old Projection Matrix
	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix


	glEnable(GL_LIGHTING);
	glEnable(GL_DEPTH_TEST);
}
void	CFXManager::BlurEffect(float _nStrength)
{
	if(!m_bFirsTime )
	{
		//If it's not the first time, we can apply the fx texture,
		//to our current view to make blur
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(1.0f,1.0f,1.0f,_nStrength);
		glBegin(GL_QUADS);
		glTexCoord2f(0.0f,0.0f);glVertex2i(0,0);
		glTexCoord2f(1.0f,0.0f);glVertex2i(g_nWd,0);
		glTexCoord2f(1.0f,1.0f);glVertex2i(g_nWd,g_nHt);
		glTexCoord2f(0.0f,1.0f);glVertex2i(0,g_nHt);
		
		
		glEnd();
		glDisable(GL_BLEND);
	}
}
void	CFXManager::GlowEffect()
{

	//Copy original pic to fx texture
	glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 0, 0, m_pcFXTex->GetWidth(), m_pcFXTex->GetHeight(), 0);
	glEnable(GL_BLEND);
	glBlendFunc(GL_DST_COLOR,GL_ONE);
	
	glBegin(GL_QUADS);

	float nOffset,nAlpha;
	for(int i=0;i<10;i++)
	{
		nOffset=i*10;
		nAlpha=0.1f-(float(i)/9.0f)*0.1f;
		glColor4f(nAlpha,nAlpha,nAlpha,nAlpha);
		
		glTexCoord2f(0.0f,0.0f);glVertex2i(-nOffset		,-nOffset*0.5f);
		glTexCoord2f(1.0f,0.0f);glVertex2i(g_nWd+nOffset,-nOffset*0.5f);
		glTexCoord2f(1.0f,1.0f);glVertex2i(g_nWd+nOffset,g_nHt+nOffset*0.5f);
		glTexCoord2f(0.0f,1.0f);glVertex2i(-nOffset		,g_nHt+nOffset*0.5f);
		
		
	}
	glEnd();
	glDisable(GL_BLEND);



}