#include "Managers/CMaterialManager.hpp"
#include "Managers/CShaderManager.hpp"
#include "Managers/CTextureManager.hpp"
#include "Globals/Globals.hpp"


//Materials
#include "Materials/CDefaultMat.hpp"
#include "Materials/CBlankMat.hpp"
#include "Materials/CTctMat.hpp"


#include "ErrorCheck.h"

CMaterialManager *g_pcMatMan=NULL;

CMaterialManager::CMaterialManager()
:bStorageOpened(false)
{
	if(g_pcShaderMan==NULL)FATALERROR("ShaderManager must be create before MaterialManager");
	if(g_pcTexMan==NULL)FATALERROR("TextureManager must be create before MaterialManager");
	
	m_pcDefaultMat=NULL;

}
CMaterialManager::~CMaterialManager()
{
	m_cItems.ClearData();
	m_cItems.Clear();
}

void CMaterialManager::InitMaterials()
{
	//This is for our shader storage
	
	
	/*
	SetCurrentDirectory("D:\\Shaderiai\\Work\\FrameWork 1.01");
	StartBuildShaderStorage();
	SetCurrentDirectory("D:\\Shaderiai\\Work\\FrameWork 1.01\\Executable\\External");
	AppendShader(true,"ShaderSource\\grass.vert");
	AppendShader(false,"ShaderSource\\grass.frag");
	AppendShader(true,"ShaderSource\\paralax_bumpmap.vert");
	AppendShader(false,"ShaderSource\\paralax_bumpmap.frag");
	AppendShader(true,"ShaderSource\\terrain.vert");
	AppendShader(false,"ShaderSource\\terrain.frag");
	EndBuild();*/
	

	
	
	CMaterial *pcNewMat;
	m_pcDefaultMat=pcNewMat=new CDefaultMat();AddCustomMaterial(pcNewMat);
	pcNewMat=new CBlankMat();AddCustomMaterial(pcNewMat);
}
void		CMaterialManager::AddCustomMaterial(CMaterial *pcMaterial)
{
	ASSERT(NameExists(pcMaterial->GetName())==NULL,"Material with name %s already exists",pcMaterial);
	AddItem(pcMaterial->GetName(),pcMaterial);
}
CMaterial  *CMaterialManager::LoadTctMaterial  (const char *strMatName)
{
	GetFullPath(g_sApp.strMainDir,strMatName,m_strMatName);

	CMaterial* mat;
	if(FindItem(m_strMatName,mat))
	{
		return mat;
	}
	else
	{
		mat = new CTctMat(m_strMatName);
		m_cItems.Add(m_strMatName,mat);
		return mat;
	}
}


CMaterial  *CMaterialManager::GetDefaultMat()
{
	return m_pcDefaultMat;
}

CMaterial   *CMaterialManager::GetMaterial(const char *strMatName)
{
	
	CMaterial *pcMat;
	if(FindItem(strMatName,pcMat))
	{
		return pcMat;
	}
	else
	{
		DEBUGMSG("Material %s was not found",strMatName);
		return m_pcDefaultMat;
	}

}

void	CMaterialManager::StartBuildShaderStorage()
{
	fStorageFile[0]=fopen("Src\\Shaders\\ShaderMem\\ShaderStorage.hpp","wt");
	if(fStorageFile[0]==NULL)
	{
		FATALERROR("Failed to open ShaderStorage.hpp");
		return;
	}
	fStorageFile[1]=fopen("Src\\Shaders\\ShaderMem\\ShaderStorage.cpp","wt");
	if(fStorageFile[1]==NULL)
	{
		fclose(fStorageFile[0]);
		FATALERROR("Failed to open ShaderStorage.cpp");
		return;
	}
	
	bStorageOpened=true;
	
	//Header initial input
	fprintf(fStorageFile[0],"#ifndef SHADERSTORAGE_HPP\n");
	fprintf(fStorageFile[0],"#define SHADERSTORAGE_HPP\n\n");
	//Cpp initial input
	fprintf(fStorageFile[1],"#include \"ShaderStorage.hpp\"\n\n");
	
}
void	CMaterialManager::AppendShader(bool bVSorFS,const char *strShFName)
{
	if(!bStorageOpened)
	{
		FATALERROR("No storage opened");
		return ;
	}
	FILE *fShader=fopen(strShFName,"rt");
	if(fShader==NULL)
	{	
		FATALERROR("AppendShader():Couldnt open %s",strShFName);
		return;
	}
	char strShaderName[255];
	char strTmp[255];
	char *strSlash;
	strcpy(strShaderName,strShFName);
	int i;
	//Find the real shader name , remove .vert or .frag
	for(i=int(strlen(strShaderName)-1);i>0;i--)
	{
		if(strShaderName[i]=='.')
		{
			strShaderName[i]='\0';
			break;
		}
	}
	//Remove slashes
	strSlash=strstr(strShaderName,"\\");
	if(strSlash)
	{
		int i=1;
		while(strSlash[i]!='\0')
		{
			strTmp[i-1]=strSlash[i];
			i++;
		}
		strTmp[i-1]='\0';
		strcpy(strShaderName,strTmp);
	}
	
	
	if(bVSorFS)strcat(strShaderName,"VS");
	else strcat(strShaderName,"FS");
	
	//Header fill
	fprintf(fStorageFile[0],"extern char %s[];\n",strShaderName);
	
	//Cpp shader header
	fprintf(fStorageFile[1],"\nchar %s[]={\n\t\"\\n",strShaderName);
	//Cpp fill
	while(feof(fShader)==FALSE)
	{
		char strChar=getc(fShader);
		if((strChar>31 && strChar<127) || strChar=='\t')
		{
			if(strChar=='\t')
			{
				fprintf(fStorageFile[1]," ");
			}else fprintf(fStorageFile[1],"%c",strChar);
			
		}else
		if(strChar=='\n')
		{
			fprintf(fStorageFile[1],"   \\\n\\n");
		}
		
	}
	
	fprintf(fStorageFile[1],"\t\"};",strShaderName);
	
	
	fclose(fShader);
	
}
void	CMaterialManager::EndBuild()
{
	if(!bStorageOpened)
	{
		FATALERROR("No storage opened");
		return ;
	}
	
	//Header ending
	fprintf(fStorageFile[0],"\n#endif\n");
	
	fclose(fStorageFile[0]);
	fclose(fStorageFile[1]);
	bStorageOpened=false;
}