#include "Managers/CModelManager.hpp"
#include "Managers/CTextureManager.hpp"
#include "Models/Loaders/CTctLoader.hpp"
#include "Globals/Globals.hpp"

#include "ErrorCheck.h"

CModelManager *g_pcModelMan;

CModelManager::CModelManager()
{

}
CModelManager::~CModelManager()
{
	m_cItems.ClearData();
	m_cItems.Clear();
	
}
CModel* CModelManager::LoadModel(const char *strModelName)
{
	CModel		*pcNewModel;
	GetFullPath(g_sApp.strMainDir,strModelName,m_strFullPath);
	if(FindItem(m_strFullPath,pcNewModel))
	{
		return pcNewModel;
	}
	else
	{	
		pcNewModel=g_cTctLoader.LoadModel(m_strFullPath);
		AddItem(m_strFullPath,pcNewModel);
		return pcNewModel;
	}
}

CModel* CModelManager::GetModel(const char *strModelName)
{
	GetFullPath(g_sApp.strMainDir,strModelName,m_strFullPath);

	CModel* pcModel;
	if(FindItem(m_strFullPath,pcModel))
	{
		return pcModel;
	}
	else
	{
		DEBUGMSG("Model %s not found",m_strFullPath);
		return NULL;
	}
}