#include "Managers/CShaderManager.hpp"
#include "Shaders/CVertexShader.hpp"
#include "Shaders/CFragmentShader.hpp"
#include "Globals/Globals.hpp"

#include "ErrorCheck.h"


CShaderManager *g_pcShaderMan=NULL;

CShaderManager::CShaderManager():CManager()
{

}

CShaderManager::~CShaderManager()
{

	m_cItems.ClearData();
	m_cItems.Clear();

}

// ----------------------------------------------------------------------------

CShaderObject* CShaderManager::LoadFromFile(const char* strVertexFile,const char* strFragFile) 
{
	GetFullPath(g_sApp.strMainDir,strVertexFile,m_strFullVertPath);
	GetFullPath(g_sApp.strMainDir,strFragFile,m_strFullFragPath);
	m_strTempStore[0]='\0';
	strcat_s(m_strTempStore,255,strVertexFile);
	strcat_s(m_strTempStore,255,strFragFile);
	GetFullPath(g_sApp.strMainDir,m_strTempStore,m_strShaderName);

	CShaderObject* o ;
	if(FindItem(m_strShaderName,o))
	{
		return o;
	}
	else
	{
		o= new CShaderObject(m_strShaderName);

		CVertexShader* tVertexShader = new CVertexShader;
		CFragmentShader* tFragmentShader = new CFragmentShader;

		// load vertex program
		if (m_strFullVertPath!=0)
		{
			if (tVertexShader->load(m_strFullVertPath) != 0)
			{ 
				FATALERROR ( "error: can't load vertex shader!\n"); 
				delete o;
				delete tVertexShader;
				delete tFragmentShader;
				return 0;
			}
		}

		// Load fragment program
		if (m_strFullFragPath!=0)
		{
			if (tFragmentShader->load(m_strFullFragPath) != 0)
			{
				FATALERROR("error: can't load fragment shader!\n");
				delete o;
				delete tVertexShader;
				delete tFragmentShader;
				return 0;
			}
		}

		// Compile vertex program
		if (m_strFullVertPath!=0)
		{
			if (!tVertexShader->compile())
			{
				/*
				FILE *fp = fopen("shader.txt","wb");
				ASSERT(fp!=NULL,"Failed to open shader debug file");
				fwrite(tVertexShader->getShaderSource(),1,strlen(tVertexShader->getShaderSource())+1,fp);
				fclose(fp);
				*/
				DEBUGMSG ( "***COMPILER ERROR (Vertex Shader):\n");
				FATALERROR ( tVertexShader->getCompilerLog() );
				delete o;
				delete tVertexShader;
				delete tFragmentShader;
				return 0;
			}
		}

		// Compile fragment program 
		if (m_strFullFragPath!=0)
		{
			if (!tFragmentShader->compile())
			{
				DEBUGMSG ("***COMPILER ERROR (Fragment Shader):\n");
				FATALERROR (tFragmentShader->getCompilerLog() );

				delete o;
				delete tVertexShader;
				delete tFragmentShader;
				return 0;

			}
		}

		// Add to object    
		if (m_strFullVertPath!=0) o->addShader(tVertexShader);
		if (m_strFullFragPath!=0) o->addShader(tFragmentShader); 

		// link 
		if (!o->link())
		{
			DEBUGMSG ( "**LINKER ERROR\n");
			FATALERROR (o->getLinkerLog() );
			delete o;
			delete tVertexShader;
			delete tFragmentShader;
			return 0;
		}

		AddItem(m_strShaderName,o);
		
		
		o->manageMemory();
		
		return o;
	}

	
}

// ----------------------------------------------------------------------------

CShaderObject* CShaderManager::LoadFromMemory(const char *strTempName,const char* strVertexMem, const char* strFragMem)
{

	GetFullPath(g_sApp.strMainDir,strTempName,m_strShaderName);

	CShaderObject* o;
	if(FindItem(m_strShaderName,o))
	{
		return o;
	}
	else
	{
		o= new CShaderObject(m_strShaderName);

		CVertexShader* tVertexShader = new CVertexShader;
		CFragmentShader* tFragmentShader = new CFragmentShader;

		// get vertex program
		if (strVertexMem!=0)
			tVertexShader->LoadFromMemory(strVertexMem);

		// get fragment program
		if (strFragMem!=0)
			tFragmentShader->LoadFromMemory(strFragMem);

		// Compile vertex program
		if (strVertexMem!=0)
		{
			if (!tVertexShader->compile())
			{
				FATALERROR ( "***COMPILER ERROR (Vertex Shader):\n");
				FATALERROR ( tVertexShader->getCompilerLog() );
				delete o;
				delete tVertexShader;
				delete tFragmentShader;
				return 0;
			}
		}

		// Compile fragment program 
		if (strFragMem!=0)
		{
			if (!tFragmentShader->compile())
			{
				FATALERROR ("***COMPILER ERROR (Fragment Shader):\n");
				FATALERROR (tFragmentShader->getCompilerLog() );

				delete o;
				delete tVertexShader;
				delete tFragmentShader;
				return 0;

			}
		}

		// Add to object    
		if (strVertexMem!=0) o->addShader(tVertexShader);
		if (strFragMem!=0) o->addShader(tFragmentShader); 

		// link 
		if (!o->link())
		{
			FATALERROR ( "**LINKER ERROR\n");
			FATALERROR ( o->getLinkerLog() );
			delete o;
			delete tVertexShader;
			delete tFragmentShader;
			return 0;
		}
			
		AddItem(m_strShaderName,o);
		
		
		o->manageMemory();
		
		return o;
	
	}


	
}

// ----------------------------------------------------------------------------

bool  CShaderManager::Free(CShaderObject* o)
{
	
	CShaderObject			  *pcCurShader;
	HashItem <CShaderObject*> *pcItem=m_cItems.Next(NULL);
	
	while(pcItem)
	{
		pcCurShader=pcItem->data;
		if(o==pcCurShader)
		{
			m_cItems.Remove(pcItem->getKey());
			delete pcCurShader;
			return true;
		}
		pcItem=m_cItems.Next(pcItem);
	}
	return false;


	/*
	vector<CShaderObject*>::iterator  i=sShaderObjList.begin();
	while (i!=sShaderObjList.end()) 
	{
		if ((*i)==o)
		{
			sShaderObjList.erase(i);
			delete o;
			return true;
		}
		i++;
	}   
	return false;
	*/
}

// ----------------------------------------------------------------------------


