#include "CTerrainManager.hpp"
#include "Managers/CTextureManager.hpp"
#include "Collision\CMiscCollisions.hpp"
#include "CCollisionManager.hpp"
#include "Globals/Globals.hpp"



#include "ErrorCheck.h"

CTerrainManager *g_pcTerrainMan;

CTerrainManager::CTerrainManager(const char *strTerrainDir,const char *strTerrainTexDir)
{
	strcpy_s(m_strTerrainDir,255,strTerrainDir);
	strcpy_s(m_strTerrainTexDir,255,strTerrainTexDir);

}
CTerrainManager::~CTerrainManager()
{

	Clear();
}
void	CTerrainManager::Clear()
{
	m_cItems.ClearData();
	m_cItems.Clear();
}

void	CTerrainManager::LoadTerrain(const char *strFileName)
{	
	SetDir(m_strTerrainDir);
	g_pcTexMan->SetDir(m_strTerrainTexDir);
	CTerrainSector *m_pcNewTerrain;
	
	GetFullPath(g_sApp.strMainDir,strFileName,m_strFullPath);
	

	if(FindItem(m_strFullPath,m_pcNewTerrain))
	{
		FATALERROR("%s already exists",m_strFullPath);
	}
	else
	{
		m_pcNewTerrain=new CTerrainSector(-1,-1);

		m_pcNewTerrain->OpenTerrain(m_strFullPath);

		AddItem(m_strFullPath,m_pcNewTerrain);
	}

}

void	CTerrainManager::Render()
{
	for(HashItem<CTerrainSector*> *pcItem=m_cItems.Next(NULL);
		pcItem!=NULL;
		pcItem=m_cItems.Next(pcItem))
	{

		pcItem->data->Render();
	}
}

CTerrainSector * CTerrainManager::GetSector(int _x,int _y)
{

	for(HashItem<CTerrainSector*> *pcItem=m_cItems.Next(NULL);
		pcItem!=NULL;
		pcItem=m_cItems.Next(pcItem))
	{
		if(pcItem->data->m_nSectorX==_x && pcItem->data->m_nSectorY==_y)
		{
			return pcItem->data;
		}
	}
	return NULL;
}

void	CTerrainManager::RandomLoad()
{
	Clear();
	int xx,yy;
	FILE *fp;
	char strFileName[255];
	
	SetDir(m_strTerrainDir);
	g_pcTexMan->SetDir(m_strTerrainTexDir);
	for(xx=-5;xx<5;xx++)
		for(yy=-5;yy<5;yy++)
	{
		sprintf(strFileName,"ter%c%d%c%d.ter",
			xx<0?'n':'a',
			abs(xx),
			yy<0?'n':'a',
			abs(yy));
		
		GetFullPath(g_sApp.strMainDir,strFileName,m_strFullPath);
		fp=fopen(m_strFullPath,"rt");
		if(fp!=NULL)
		{
			fclose(fp);
			LoadTerrain(strFileName);
		}
	
	}
}void	CTerrainManager::ReLoadTerrain(int _x,int _y)
{
	SetDir(m_strTerrainDir);
	g_pcTexMan->SetDir(m_strTerrainTexDir);
	char strFileName[255];
	sprintf(strFileName,"ter%c%d%c%d.ter",
			_x<0?'n':'a',
			abs(_x),
			_y<0?'n':'a',
			abs(_y));
	GetFullPath(g_sApp.strMainDir,strFileName,m_strFullPath);
	
	
	for(HashItem<CTerrainSector*> *pcItem=m_cItems.Next(NULL);
		pcItem!=NULL;
		pcItem=m_cItems.Next(pcItem))
	{
		if(pcItem->data->m_nSectorX==_x && pcItem->data->m_nSectorY==_y)
		{
			pcItem->data->OpenTerrain(m_strFullPath);
		}
	}

}
Vector3D CTerrainManager::CalculateHeight(Vector3D v1,Vector3D v2,Vector3D v3,Vector3D v4,float xx,float zz,bool bScdMode)
{

	Vector3D c,b,e,n,c2;
	b=Vector3D(xx,10000,zz);
	e=Vector3D(xx,-10000,zz);

	//v1 v4
	//v2 v3
	
	//First mode v1,v3,v2 and v1,v4,v3
	//Scn   mode v1,v4,v2 and v2,v4,v3


	if(bScdMode)
	{
		if(FindTriLineCollision(v1,v4,v2,b,e,c,n,false))
		{
		
			//glColor3f(0.0f,0.4f,0);
			//glBegin(GL_TRIANGLES);
			//glVertex3fv(v1);
			//glVertex3fv(v4);
			//glVertex3fv(v2);
			//glEnd();
			//glBegin	(GL_LINES);
			//glVertex3fv(v1);
			//glVertex3fv(v1+n*30.0f);
			//glVertex3fv(v4);
			//glVertex3fv(v4+n*30.0f);
			//glVertex3fv(v2);
			//glVertex3fv(v2+n*30.0f);
			//glEnd();
		
		
			return c;
		}
		else
		{
			if(FindTriLineCollision(v2,v4,v3,b,e,c,n,false))
			{
				//glColor3f(0.4f,0,0);
				//glBegin(GL_TRIANGLES);
				//glVertex3fv(v2);
				//glVertex3fv(v4);
				//glVertex3fv(v3);
				//glEnd();
				//
				//glBegin	(GL_LINES);
				//glVertex3fv(v2);
				//glVertex3fv(v2+n*30.0f);
				//glVertex3fv(v4);
				//glVertex3fv(v4+n*30.0f);
				//glVertex3fv(v3);
				//glVertex3fv(v3+n*30.0f);
				//glEnd();
				return c;
			}
			else 
			{
				GetClosestPointOnTriEdges(v1,v4,v2,b,c);
				GetClosestPointOnTriEdges(v2,v4,v3,b,c2);
				if((b.x-c.x)*(b.x-c.x)+(b.z-c.z)*(b.z-c.z)<
				   (b.x-c2.x)*(b.x-c2.x)+(b.z-c2.z)*(b.z-c2.z))
				   return c;
				else return c2;
			}
		}
	
	}
	else
	{
		if(FindTriLineCollision(v1,v3,v2,b,e,c,n,false))
		{
		
			//glColor3f(0.0f,0.4f,0);
			//glBegin(GL_TRIANGLES);
			//glVertex3fv(v1);
			//glVertex3fv(v3);
			//glVertex3fv(v2);
			//glEnd();
			//glBegin	(GL_LINES);
			//glVertex3fv(v1);
			//glVertex3fv(v1+n*30.0f);
			//glVertex3fv(v3);
			//glVertex3fv(v3+n*30.0f);
			//glVertex3fv(v2);
			//glVertex3fv(v2+n*30.0f);
			//glEnd();
		
		
		
			return c;
		}
		else
		{
			if(FindTriLineCollision(v1,v4,v3,b,e,c,n,false))
			{
				//glColor3f(0.4f,0,0);
				//glBegin(GL_TRIANGLES);
				//glVertex3fv(v1);
				//glVertex3fv(v4);
				//glVertex3fv(v3);
				//glEnd();
				//
				//glBegin	(GL_LINES);
				//glVertex3fv(v1);
				//glVertex3fv(v1+n*30.0f);
				//glVertex3fv(v3);
				//glVertex3fv(v3+n*30.0f);
				//glVertex3fv(v4);
				//glVertex3fv(v4+n*30.0f);
				//glEnd();
				return c;
			}
			else 
			{
				GetClosestPointOnTriEdges(v1,v3,v2,b,c);
				GetClosestPointOnTriEdges(v1,v4,v3,b,c2);
				if((b.x-c.x)*(b.x-c.x)+(b.z-c.z)*(b.z-c.z)<
				   (b.x-c2.x)*(b.x-c2.x)+(b.z-c2.z)*(b.z-c2.z))
				   return c;
				else return c2;
			}
		}
	}

}
bool	CTerrainManager::GetHeight(Vector3D& vPos)
{
	int nSX=int(vPos.x/9900.0f);
	int nSY=int(vPos.z/9900.0f);
	CTerPoint *pp[4];

	CTerrainSector *pcColSc=GetSector(nSX,nSY);
	if(pcColSc)
	{
		nSX=int((vPos.x-nSX*9900.0f)/100.0f);
		nSY=int((vPos.z-nSY*9900.0f)/100.0f);
		if(vPos.x<0.0f)nSX--;
		if(vPos.z<0.0f)nSY--;
		pp[0]=pcColSc->GetPoint(nSX,nSY,true);
		pp[1]=pcColSc->GetPoint(nSX+1,nSY,true);
		pp[2]=pcColSc->GetPoint(nSX+1,nSY+1,true);
		pp[3]=pcColSc->GetPoint(nSX,nSY+1,true);
		
		


		if(pp[0] && pp[1] && pp[2] && pp[3])
		{
		
			//glBegin	(GL_LINES);
			//for(int i=0;i<4;i++)
			//{
			//	glVertex3fv(pp[i]->m_vPoint);
			//	glVertex3fv(pp[i]->m_vPoint+Vector3D(0,30,0));
			//}
			//glEnd();
		
		
			vPos=CalculateHeight(
				pp[0]->m_vPoint,
				pp[1]->m_vPoint,
				pp[2]->m_vPoint,
				pp[3]->m_vPoint,vPos.x,vPos.z,(nSY&1)!=0);
			return true;
		}
		else return false;


	}
	return false;
}

void CTerrainManager::InitCollisionData()
{
	CTerrainSector *pcTerSector;
	
	unsigned		nIndCount=10000*m_cItems.Count();
	unsigned		nTriCount=(99)*(99)*2*m_cItems.Count();
	unsigned		nOffset;
	unsigned		nCurSector=0;
	unsigned		nYYoff,nYYoffPlusOne;
	g_pcColMan->DataInit();	
	
	for(HashItem<CTerrainSector*> *pcItem=m_cItems.Next(NULL);
		pcItem!=NULL;
		pcItem=m_cItems.Next(pcItem))
	{
	
	
		pcTerSector=pcItem->data;
		
		unsigned xx,yy;
		
		nOffset=nCurSector*10000;
		
		//Indices
		for(yy=0;yy<pcTerSector->m_nLt;yy++)
		{
			for(xx=0;xx<pcTerSector->m_nWd;xx++)
			{
				Vector3D v=pcTerSector->GetPoint(xx,yy)->m_vPoint;
				g_pcColMan->AddVertex(v.x,v.y,v.z);
			}
		}
		
		//Index num is yy*pcTerSector->m_nWd+xx
		
		//Tri Add
		for(yy=0;yy<pcTerSector->m_nLt-1;yy++)
		{
			//To not calculate this value ech time
			nYYoff = yy*pcTerSector->m_nWd;
			nYYoffPlusOne = (yy+1)*pcTerSector->m_nWd;

			for(xx=0;xx<pcTerSector->m_nWd-1;xx++)
			{
				g_pcColMan->AddTriIndices(
					nYYoff+xx+1+nOffset,
					nYYoff+xx+nOffset,
					nYYoffPlusOne+xx+nOffset);
				
				g_pcColMan->AddTriIndices(
					nYYoffPlusOne+xx+1+nOffset,
					nYYoff+xx+1+nOffset,
					nYYoffPlusOne+xx+nOffset);
				
			}
		}	

		nCurSector++;
		
	}
	g_pcColMan->DataFinish();
	
}