#include "Materials/CTctAttributes.hpp"
#include "Shaders/CShaderObject.hpp"
#include "Utils/MiscFuncs.hpp"

#include "ErrorCheck.h"


CTctAttribute::CTctAttribute(const char *strName)
{
	m_strName = NULL;
	strAllocNCopy(&m_strName,strName);
}
CTctAttribute::~CTctAttribute()
{
	free(m_strName);
}

CTctAttrFloat::CTctAttrFloat(const char *strName,float fValue):CTctAttribute(strName),m_fValue(fValue){}
void CTctAttrFloat::SetAttribute(CShaderObject *pcShader){pcShader->sendUniform1f(m_strName,m_fValue);}

CTctAttrInt::CTctAttrInt(const char *strName,int nValue):CTctAttribute(strName),m_nValue(nValue){}
void CTctAttrInt::SetAttribute(CShaderObject *pcShader){pcShader->sendUniform1i(m_strName,m_nValue);}

CTctAttrVec2::CTctAttrVec2(const char *strName,Vector2D vValue):CTctAttribute(strName),m_vValue(vValue){}
void CTctAttrVec2::SetAttribute(CShaderObject *pcShader){pcShader->sendUniform2f(m_strName,m_vValue.x,m_vValue.y);}

CTctAttrVec3::CTctAttrVec3(const char *strName,Vector3D vValue):CTctAttribute(strName),m_vValue(vValue){}
void CTctAttrVec3::SetAttribute(CShaderObject *pcShader){pcShader->sendUniform3f(m_strName,m_vValue.x,m_vValue.y,m_vValue.z);}

CTctAttrVec4::CTctAttrVec4(const char *strName,Vector4D vValue):CTctAttribute(strName),m_vValue(vValue){}
void CTctAttrVec4::SetAttribute(CShaderObject *pcShader){pcShader->sendUniform4f(m_strName,m_vValue.x,m_vValue.y,m_vValue.z,m_vValue.w);}

CTctAttrFloatPtr::CTctAttrFloatPtr(const char *strName,float *pfValue):CTctAttribute(strName),m_pfValue(pfValue){}
void CTctAttrFloatPtr::SetAttribute(CShaderObject *pcShader){pcShader->sendUniform1f(m_strName,*m_pfValue);}

CTctAttrIntPtr::CTctAttrIntPtr(const char *strName,int *pnValue):CTctAttribute(strName),m_pnValue(pnValue){}
void CTctAttrIntPtr::SetAttribute(CShaderObject *pcShader){pcShader->sendUniform1i(m_strName,*m_pnValue);}


CTctAttrVec3Ptr::CTctAttrVec3Ptr(const char *strName,Vector3D *pvValue):CTctAttribute(strName),m_pvValue(pvValue){}
void CTctAttrVec3Ptr::SetAttribute(CShaderObject *pcShader){pcShader->sendUniform3f(m_strName,m_pvValue->x,m_pvValue->y,m_pvValue->z);}