#include "Animations/CAnimation.hpp"
#include "Animations/CSubAnim.hpp"

#include "ErrorCheck.h"


CAnimation::CAnimation()
{
}
CAnimation::~CAnimation()
{
	for(LinkedListItem<CSubAnim*> *pcItem = m_aSubAnimLst.Next(NULL);
		pcItem;
		pcItem = m_aSubAnimLst.Next(pcItem))
	{
		delete pcItem->data;
	}
	m_aSubAnimLst.Clear();

}
unsigned CAnimation::GetSubAnimCount()
{
	return 	m_aSubAnimLst.Count();
}
void	 CAnimation::AddSubAnimation(CSubAnim * pcSubAnim)
{
	m_aSubAnimLst.AddAtEnd(pcSubAnim);
}
CSubAnim *	CAnimation::GetSubAnimByNumber(unsigned n)
{
	unsigned nCur = 0;
	for(LinkedListItem<CSubAnim*> *pcItem = m_aSubAnimLst.Next(NULL);
		pcItem;
		pcItem = m_aSubAnimLst.Next(pcItem))
	{
		if(nCur==n)return pcItem->data;
		nCur++;
	}
	FATALERROR("Sub Anim not found , searched for %d, current %d",n,nCur);
	return NULL;
}
