#include "Animations/CAnimationPlayer.hpp"
#include "Animations/CAnimation.hpp"
#include "Animations/CSubAnim.hpp"
#include "Models/CRenderObject.hpp"
#include "Models/CModelUtils.hpp"

#include "Types/Vector3D.h"
#include "Types/Quaternion.h"
#include "Types/Matrix3D.h"

#include "ErrorCheck.h"

CAnimationPlayer::CAnimationPlayer(CAnimation *pcAnimation)
:m_pcAnimation(pcAnimation)
,m_pcSubObjBinds(NULL)
,m_nBindCount(0)
,m_fProgress(0.0f)
,m_pcLastBindedModel(NULL)
{
}
CAnimationPlayer::~CAnimationPlayer()
{
	Clear();
}

void	CAnimationPlayer::Clear()
{
	if(m_pcSubObjBinds)
	{
		delete []m_pcSubObjBinds;
		m_nBindCount = 0;
	}
}

void	CAnimationPlayer::GenerateAnimationData(CRenderObject *pcObject)
{
	//Don't generate sub-objects for the same model
	if(m_pcLastBindedModel==pcObject->GetModel())return;
	else m_pcLastBindedModel = pcObject->GetModel();

	Clear();

	m_nBindCount = pcObject->GetModel()->GetRenderDataCount();
	m_pcSubObjBinds = new CSubAnim*[m_nBindCount];
	for(unsigned i=0;i<pcObject->GetModel()->GetRenderDataCount();i++)
	{
		m_pcSubObjBinds[i] = NULL;
	}
	for(unsigned i=0;i<pcObject->GetModel()->GetRenderDataCount();i++)
	{
		const char *strRDName = pcObject->GetModel()->GetRenderData(i)->GetName();
		for(LinkedListItem<CSubAnim*> *pcItem = m_pcAnimation->GetNextSubAnim(NULL);
			pcItem;
			pcItem = m_pcAnimation->GetNextSubAnim(pcItem))
		{
			if(_strcmpi(pcItem->data->GetName(),strRDName)==0)
			{
				m_pcSubObjBinds[i] = pcItem->data;
				break;
			}
		}
	}

}
bool	CAnimationPlayer::SetMatrixForSubObject(unsigned nObject)
{
	//If binded sub-object exists set up matrix for him
	if(nObject<m_nBindCount && m_pcSubObjBinds[nObject]!=NULL)
	{
		
		m_pcSubObjBinds[nObject]->SetRotationMatrix(m_fProgress);
		
		return true;
	}
	else
	{
		return false;
	}
}
