#include "Stdafx.h"
#include "Animations/CSubAnim.hpp"
#include "Utils/MiscFuncs.hpp"

#include "ErrorCheck.h"

CSubAnim::CSubAnim(const char *strName)
:m_pcParent(NULL)
,m_fLastT(-1.0f)
{
	m_strName = NULL;
	strAllocNCopy(&m_strName,strName);

	InterpolatePositions = &CSubAnim::InterpolatePositions_Arr;
	InterpolateScales    = &CSubAnim::InterpolateScales_Arr;
	InterpolateRotations = &CSubAnim::InterpolateRotations_Arr;
}
CSubAnim::~CSubAnim()
{

	m_cAnimLst.Clear();

	free(m_strName);
}
void	CSubAnim::Begin()
{
}
void	CSubAnim::Add(CAnimEntity  cAnimEntity)
{
	m_cAnimLst.Add(cAnimEntity);
}
void	CSubAnim::End()
{
	ASSERT(m_cAnimLst.Length()!=0,"Warning no animation");
	m_fScale = float(m_cAnimLst.Length()-1);
}
void CSubAnim::SetPositionAnim(bool bEnable)
{
	InterpolatePositions = bEnable?(&CSubAnim::InterpolatePositions_Arr):(&CSubAnim::InterpolatePositions_NoArr);
}
void CSubAnim::SetScaleAnim(bool bEnable)
{
	InterpolateScales    = bEnable?(&CSubAnim::InterpolateScales_Arr):(&CSubAnim::InterpolateScales_NoArr);
}
void CSubAnim::SetRotAnim(bool bEnable)
{
	InterpolateRotations = bEnable?(&CSubAnim::InterpolateRotations_Arr):(&CSubAnim::InterpolateRotations_NoArr);
}




void	CSubAnim::GetAnimationValues(float t,Vector3D& vPosition,Vector3D& vScale,Quaternion& qRot)
{
	//If we out interpolation value, clamp it
	if(t<=0.0f)
	{
		vPosition = m_cAnimLst[0].m_vPosition;
		vScale    = m_cAnimLst[0].m_vScale;
		qRot      = m_cAnimLst[0].m_qRot;
	}
	else if(t>=1.0f)
	{
		vPosition = m_cAnimLst[m_cAnimLst.Length()-1].m_vPosition;
		vScale    = m_cAnimLst[m_cAnimLst.Length()-1].m_vScale;
		qRot      = m_cAnimLst[m_cAnimLst.Length()-1].m_qRot;
	}
	else
	{
		//Calculate index and t for animation getting from array
		float i = t * m_fScale;
		m_nEntityIndex = int(i);
		if(m_cAnimLst.Length()-1==m_nEntityIndex)m_nEntityIndex = m_cAnimLst.Length()-2;
		ASSERT(m_nEntityIndex > -1 && m_nEntityIndex < (int(m_cAnimLst.Length()) - 1),"Index was calculated incorrectly :0<%d<%d ",m_nEntityIndex,(int(m_cAnimLst.Length()) - 1));
		t = i - m_nEntityIndex;                         
		ASSERT(t >= 0.0 && t < 1.0,"t range must be 0.0f..1.0f");

		(this->*InterpolatePositions)(vPosition,t);
		(this->*InterpolateScales)(vScale,t);
		(this->*InterpolateRotations)(qRot,t);
	}

}
void	CSubAnim::SetRotationMatrix(float t)
{
	if(t==m_fLastT)
	{
		glMultMatrixf(m_mLastMatrix);
		glScalef(m_vLastScale.x,m_vLastScale.y,m_vLastScale.z);
	}
	else
	{
		float	  m[16];
		Vector3D   vPos,vScale;
		Quaternion qRot;
		Transform3D tTrans;

		GetAnimationValues(t,vPos,vScale,qRot);

		tTrans.m = qRot.getMatrix();
		//Opengl's evil doings =]
		tTrans.m.transpose();
		tTrans.v = vPos;
		tTrans.buildHomogeneousMatrix(m);

		//Save data if necessary
		m_fLastT = t;
		m_vLastScale = vScale;
		memcpy(m_mLastMatrix,m,sizeof(float)*16);

		glMultMatrixf(m);
		glScalef(vScale.x,vScale.y,vScale.z);
	}

	

	//TODO: set vScale directly into m
}


