#include "AppUtils/CLoadingWnd.hpp"
#include <stdio.h>

#include "resource.h"


#include "ErrorCheck.h"

CLoadingWnd g_cLoadingWnd;

BOOL CALLBACK LoadingDlgProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static char settextmessage[256];

	switch (message)
	{
	case WM_INITDIALOG:
		{
			settextmessage[0] = '\0';
			return true;
		}

	case WM_PAINT:
		{
			// Window layout:
			// Borders on all sides: 4% of window width
			// WM_SETTEXT message at bottom: 16% of window height

			HDC hDC;
			PAINTSTRUCT ps;
			HFONT hBigFont;
			HFONT hSmallFont;
			HPEN hLightPen;
			HPEN hDarkPen;
			RECT rect;
			int width, height;
			int border, settextheight, loadingheight;

			// Start painting
			hDC = BeginPaint(hWnd, &ps);
			SetBkColor(hDC, GetSysColor(COLOR_BTNFACE));

			// Calculate dimensions
			GetClientRect(hWnd, &rect);
			width = rect.right - rect.left;
			height = rect.bottom - rect.top;
			border = (int)(.04 * width);
			settextheight = (int)(.16 * height);
			loadingheight = height - settextheight - 2 * border;

			// Create fonts and pens
			hBigFont = CreateFont(-GetDeviceCaps(hDC, LOGPIXELSY) * 12 / 72, 0, 0, 0, FW_BOLD, false, false, false, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, "MS Sans Serif");
			hSmallFont = CreateFont(-GetDeviceCaps(hDC, LOGPIXELSY) * 8 / 72, 0, 0, 0, FW_NORMAL, false, false, false, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, "MS Sans Serif");
			hLightPen = CreatePen(PS_SOLID, 0, GetSysColor(COLOR_BTNHILIGHT));
			hDarkPen = CreatePen(PS_SOLID, 0, GetSysColor(COLOR_BTNSHADOW));

			// Draw "Loading, please wait" message
			rect.left = border + 2;
			rect.right = width - border;
			rect.top = border + 2;
			rect.bottom = border + loadingheight;
			SelectObject(hDC, hBigFont);
			SetBkMode(hDC, TRANSPARENT);
			SetTextColor(hDC, GetSysColor(COLOR_BTNHILIGHT));
			DrawText(hDC, "Loading, please wait", -1, &rect, DT_CENTER | DT_VCENTER | DT_SINGLELINE);
			rect.left -= 2; rect.top -= 2;
			SetTextColor(hDC, GetSysColor(COLOR_BTNSHADOW));
			DrawText(hDC, "Loading, please wait", -1, &rect, DT_CENTER | DT_VCENTER | DT_SINGLELINE);

			// Draw WM_SETTEXT message
			rect.left += 5;
			rect.top = border + loadingheight;
			rect.bottom = height - border;
			SelectObject(hDC, hSmallFont);
			SetBkMode(hDC, OPAQUE);
			SetTextColor(hDC, GetSysColor(COLOR_BTNTEXT));
			DrawText(hDC, settextmessage, -1, &rect, DT_LEFT | DT_VCENTER | DT_SINGLELINE);

			// Draw border
			SelectObject(hDC, hDarkPen);
			MoveToEx(hDC, border, height - border, NULL);
			LineTo(hDC, border, border);
			LineTo(hDC, width - border, border);
			SelectObject(hDC, hLightPen);
			LineTo(hDC, width - border, height - border);
			LineTo(hDC, border, height - border);

			// End paint
			SelectObject(hDC, GetStockObject(SYSTEM_FONT));
			DeleteObject(hBigFont);
			DeleteObject(hSmallFont);
			SelectObject(hDC, GetStockObject(BLACK_PEN));
			DeleteObject(hDarkPen);
			DeleteObject(hLightPen);
			EndPaint(hWnd, &ps);
			return true;
		}

	case WM_SETTEXT:
		{
			strcpy(settextmessage, (const char *)lParam);
			strcat(settextmessage, "                  ");
			// Force immediate redraw
			InvalidateRect(hWnd, NULL, false);
			UpdateWindow(hWnd);
			return true;
		}

	default:
		{
			return false;
		}
	}
}


CLoadingWnd::CLoadingWnd()
{

}
CLoadingWnd::~CLoadingWnd()
{

}
void	CLoadingWnd::Printf(const char *fmt, ...)
{
	char		text[256];					// Holds Our String
	va_list		ap;							// Pointer To List Of Arguments
	if (fmt == NULL)						// If There's No Text
		return;								// Do Nothing

	va_start(ap, fmt);						// Parses The String For Variables
	vsprintf(text, fmt, ap);			// And Converts Symbols To Actual Numbers
	va_end(ap);								// Results Are Stored In Text

	SetWindowText(hWndLoading,text);
	
}
void	CLoadingWnd::StartLoading(HINSTANCE hInstance, HWND hWnd)
{
	hWndLoading = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_LOADING), hWnd, LoadingDlgProc);
	ShowWindow(hWndLoading, SW_SHOWNORMAL);


}

void	CLoadingWnd::EndLoading()
{
	// Get rid of loading dialog
	DestroyWindow(hWndLoading);

}
