#include "AppUtils/AppSettings.hpp"
#include "TinyXML/tinyXml.h"
#include "Utils/CFileReader.hpp"
#include "Globals/Globals.hpp"
#include "Props/CAttribute.hpp"
#include "Props/CAttributeGroup.hpp"
#include "Props/CProperties.hpp"

#include "ErrorCheck.h"


void  ChangeAttributeType(CAttribute *pcTarget)
{
	const char * strName = pcTarget->GetName();
	switch(strName[0])
	{
	case 's':
		//Do nothing, cause by default attribute is string
		break;
	case 'f':
		pcTarget->ConvertToFloat();
		break;
	case 'i':
		pcTarget->ConvertToInt();
		break;
	case 'd':
		pcTarget->ConvertToShort();
		break;
	case 'b':
		pcTarget->ConvertToBool();
		break;
	case 'v':
		if(strName[1]=='2')pcTarget->ConvertToVector2D();
		else if(strName[1]=='3')pcTarget->ConvertToVector3D();
		else DEBUGMSG("Unknown vector in attribute:%s",pcTarget->GetName());
		break;
	case 'm':
		if(strName[1]=='3')pcTarget->ConvertToMatrix3D();
		else if(strName[1]=='4')pcTarget->ConvertToMatrix4D();
		else DEBUGMSG("Unknown matrix in attribute:%s",pcTarget->GetName());
		break;
	default:
		DEBUGMSG("Unknown Type in attribute:%s",pcTarget->GetName());
	}

}

void  InitSettings()
{
	TiXmlDocument xcDoc("AppSettings");
	//Main Node
	TiXmlElement  xcMainNode( "AppSettings");
	
	//Camera Settings
	TiXmlElement  xcCamNode("Camera");
	xcCamNode.SetAttribute("EyeX",100);
	xcCamNode.SetAttribute("EyeY",100);
	xcCamNode.SetAttribute("EyeZ",100);
	
	
	xcMainNode.InsertEndChild(xcCamNode);
	xcDoc.InsertEndChild(xcMainNode);

}
void  LoadSettings(const char * _strFileName)
{

	CFileReader cFile;
	if(cFile.OpenFile(_strFileName))
	{
		TiXmlNode		*xcNode,*xcChild;
		TiXmlAttribute	*xcAttr;
		TiXmlDocument xcDoc("AppSettings");
		xcDoc.Parse((char*)cFile.GetBuffer());
		ASSERT(xcDoc.Error()==false,"Xml error - %s (%d,%d):%s",xcDoc.Value(),
			xcDoc.ErrorRow(),xcDoc.ErrorCol(),  xcDoc.ErrorDesc());
		xcNode  = xcDoc.FirstChildElement();


		CAttributeGroup *pcNewGroup;
		CAttribute		*pcNewAttr;

		//Now we can go through elements in that node
		for( xcChild = xcNode->FirstChildElement();
			 xcChild;
			 xcChild = xcChild->NextSiblingElement())
		{
			pcNewGroup = new CAttributeGroup(xcChild->Value());
			if(g_pcAppProps->AddAttrGroup(pcNewGroup))
			{
				//Go trough Attributes of the element
				for( xcAttr = xcChild->ToElement()->FirstAttribute(); 
					 xcAttr;
					 xcAttr = xcAttr->Next())
				{
					pcNewAttr = new CAttribute(xcAttr->Name(),xcAttr->Value());
					pcNewGroup->AddAttribute(pcNewAttr);
					ChangeAttributeType(pcNewAttr);
				}
			}
		}
		cFile.CloseFile();
	}
	else  DEBUGMSG("Failed to open %s, app probably will crash",_strFileName);



}
void  SaveSettings(const char * _strFileName)
{
	TiXmlDocument xcDoc("AppSettings");
	TiXmlElement  xcNode("AppSettings");
	TiXmlNode	 *xcMainNode;
	xcMainNode = xcDoc.InsertEndChild(xcNode);

	
	for(HashItem<CAttributeGroup*> *pcAttrGr = g_pcAppProps->GetNextAttrGroup(NULL);
		pcAttrGr;
		pcAttrGr = g_pcAppProps->GetNextAttrGroup(pcAttrGr))
	{
		const char *ss = pcAttrGr->data->GetName();
		TiXmlElement cNewElement( pcAttrGr->data->GetName());
		for(HashItem<CAttribute*> *pcAttrItem = pcAttrGr->data->GetNextAttribute(NULL);
			pcAttrItem;	
			pcAttrItem = pcAttrGr->data->GetNextAttribute(pcAttrItem))
		{
			pcAttrItem->data->ConvertToString();
			cNewElement.SetAttribute(pcAttrItem->data->GetName(),pcAttrItem->data->GetString());

		}
		xcMainNode->InsertEndChild(cNewElement);
	}

	//Specify full path
	char strFullPath[1024];
	strcpy_s(strFullPath,1024,g_sApp.strMainDir);
	strcat_s(strFullPath,1024,_strFileName);

	FILE *fp = fopen(strFullPath,"wt");
	if(fp)
	{
		xcDoc.Print(fp);
		fclose(fp);
	}
	else
	{

		FATALERROR("Failed to save %s file",strFullPath);
	}
}