#include "Camera/Camera.h"
#include "Utils/CKeys.h"
#include "Utils/CMouseState.h"
#include "Types/Matrix3D.h"
#include "Opengl/OpenGLExtensions.h"

#include "ErrorCheck.h"


Camera g_cMainCam;


Camera::Camera()
{
	m_vEye	= Vector3D(0.0, 0.0, 0.0);					
	m_vAt	= Vector3D(0.74f,0.74f,0.0f);				
	m_vUp	= Vector3D(0.0, 1.0, 0.0);			
	
	m_fSpeed= 0.005f;				

	m_vLookVec	= Vector3D(1.0, 0.0, 0.0);		
	m_vRightVec = Vector3D(0.0, 1.0, 0.0);		
	m_vUpVec	= Vector3D(0.0, 0.0, 1.0);		


	Matrix3D::getIdentityMatrix().buildHomogeneousMatrix(m_fModelViewTransposed);
}


///////////////////////////////// POSITION CAMERA \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*
/////
/////	This function sets the camera's position and view and up vVector.
/////
///////////////////////////////// POSITION CAMERA \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*

void Camera::PositionCamera(const Vector3D& _vEye,const Vector3D& _vAt,const Vector3D& _vUp)
{

	m_vEye = _vEye;				
	m_vAt  = _vAt;					
	if(_vUp.length()>0.0f)	m_vUp  = _vUp;				
	else m_vUp = Vector3D(0,0,1);
}

void Camera::PositionCamera(const Vector3D& _vEye,const Vector3D& _vAt)
{
	if(m_vUp.length()==0) m_vUp = Vector3D(0,0,1);
	PositionCamera(_vEye,_vAt,m_vUp);
}
void Camera::SetMatrix()
{
	glLoadIdentity();
	gluLookAt(m_vEye.x, m_vEye.y,  m_vEye.z,	
			  m_vAt.x,	  m_vAt.y,      m_vAt.z,	
			  m_vUp.x, m_vUp.y,  m_vUp.z);
			  
	//Extract from matrix look,right and up vectors (local)
	glGetFloatv( GL_MODELVIEW_MATRIX,m_fModelViewInitial);

	glGetFloatv( GL_PROJECTION_MATRIX,m_fProjectionInitial);
	
	m_vRightVec=Vector3D(m_fModelViewInitial[0],m_fModelViewInitial[4],m_fModelViewInitial[8]);
	m_vLookVec=Vector3D(m_fModelViewInitial[2],m_fModelViewInitial[6],m_fModelViewInitial[10]);
	m_vUpVec=Vector3D(m_fModelViewInitial[1],m_fModelViewInitial[5],m_fModelViewInitial[9]);

	glGetFloatv ( GL_TRANSPOSE_MODELVIEW_MATRIX_ARB, m_fModelViewTransposed );
	
	
	
}

void  Camera::CameraControls(float fDeltaTime)
{
	float nModifier=fDeltaTime*400.0f;
	if(g_cKeys.GetKey(VK_SHIFT))
		nModifier*=4.0f;

	if(g_cKeys.GetKey(VK_UP))
	{
		MoveCamera(m_fSpeed*nModifier);

	}
	if(g_cKeys.GetKey(VK_DOWN))
	{
		MoveCamera(-m_fSpeed*nModifier);
	}

	if(g_cKeys.GetKey(VK_LEFT))
	{
		Strafe(m_fSpeed*nModifier);

	}
	if(g_cKeys.GetKey(VK_RIGHT))
	{

		Strafe(-m_fSpeed*nModifier);
	}
}
bool Camera::SetViewByMouse()
{
	POINT mousePos;	
	static int middleX = g_nWd>>1;
	static int middleY = g_nHt>>1;
				
	if(!g_cMouse.GetButton(0) )return false;
	if(g_cMouse.Changed(0))
	{
		GetCursorPos(&mousePos);						
		middleX=mousePos.x;
		middleY=mousePos.y;
	}
	

						

	
	
	float angleY = 0.0f;							// This is the direction for looking up or down
	float angleZ = 0.0f;							// This will be the value we need to rotate around the Y axis (Left and Right)
	static float currentRotX = 0.0f;

	// Get the mouse's current X,Y position
	GetCursorPos(&mousePos);						

	// If our cursor is still in the middle, we never moved... so don't update the screen
	if( (mousePos.x == middleX) && (mousePos.y == middleY) ) return false;

	// Set the mouse position to the middle of our window
	SetCursorPos(middleX, middleY);							

	// Get the direction the mouse moved in, but bring the number down to a reasonable amount
	angleY = (float)( (middleX - mousePos.x) ) / 500.0f;		
	angleZ = (float)( (middleY - mousePos.y) ) / 500.0f;		

	// Here we keep track of the current rotation (for up and down) so that
	// we can restrict the camera from doing a full 360 loop.
	currentRotX -= angleZ;  

	// If the current rotation (in radians) is greater than 1.0, we want to cap it.
	//if(currentRotX > 1.0f)
	//	currentRotX = 1.0f;
	// Check if the rotation is below -1.0, if so we want to make sure it doesn't continue
	//	else if(currentRotX < -1.0f)
	//	currentRotX = -1.0f;
	// Otherwise, we can rotate the view around our position
	//	else
	{
		// To find the axis we need to rotate around for up and down
		// movements, we need to get a perpendicular vector from the
		// camera's view vector and up vector.  This will be the axis.
		Vector3D vAxis = Cross(m_vAt - m_vEye, m_vUp);
		vAxis.normalize();

		// Rotate around our perpendicular axis and along the y-axis
		RotateView(angleZ, vAxis.x, vAxis.y, vAxis.z);
		RotateView(angleY, m_vUp.x, m_vUp.y, m_vUp.z);
	}
	return true;
}

void Camera::RotateView(float angle, float x, float y, float z)
{
	Vector3D vNewView;

	// Get the view vector (The direction we are facing)
	Vector3D vView = m_vAt - m_vEye;		

	// Calculate the sine and cosine of the angle once
	float cosTheta = (float)cos(angle);
	float sinTheta = (float)sin(angle);

	// Find the new x position for the new rotated point
	vNewView.x  = (cosTheta + (1 - cosTheta) * x * x)		* vView.x;
	vNewView.x += ((1 - cosTheta) * x * y - z * sinTheta)	* vView.y;
	vNewView.x += ((1 - cosTheta) * x * z + y * sinTheta)	* vView.z;

	// Find the new y position for the new rotated point
	vNewView.y  = ((1 - cosTheta) * x * y + z * sinTheta)	* vView.x;
	vNewView.y += (cosTheta + (1 - cosTheta) * y * y)		* vView.y;
	vNewView.y += ((1 - cosTheta) * y * z - x * sinTheta)	* vView.z;

	// Find the new z position for the new rotated point
	vNewView.z  = ((1 - cosTheta) * x * z - y * sinTheta)	* vView.x;
	vNewView.z += ((1 - cosTheta) * y * z + x * sinTheta)	* vView.y;
	vNewView.z += (cosTheta + (1 - cosTheta) * z * z)		* vView.z;

	// Now we just add the newly rotated vector to our position to set
	// our new rotated view of our camera.
	m_vAt = m_vEye + vNewView;
}

void Camera::SwitchToOrthoView()
{
	glMatrixMode(GL_PROJECTION);		
	glLoadIdentity();													
	glOrtho(-1,1,-1,1,-1,1);	
	glMatrixMode(GL_MODELVIEW);	
	glLoadIdentity();					
}
///////////////////////////////// MOVE CAMERA \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*
/////
/////	This will move the camera forward or backward depending on the speed
/////
///////////////////////////////// MOVE CAMERA \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*


void Camera::MoveCamera(float speed)
{
	m_vEye -= GetLookVec()*speed;		
	m_vAt -= GetLookVec()*speed;

}
void Camera::Strafe(float speed)
{
	m_vEye-=GetRightVec()*speed;
	m_vAt-=GetRightVec()*speed;
}



