#include "Models/CModel.hpp"
#include "Models/CModelUtils.hpp"
#include "Primitives/MiscPrimitives.hpp"
#include "Utils/MiscFuncs.hpp"

#include "ErrorCheck.h"

CModel::CModel(const char *strName):CObject()
{
	m_strName = NULL;
	strAllocNCopy(&m_strName,strName);
}
CModel::~CModel()
{
	free(m_strName);
	CleanUp();
}


void CModel::CleanUp()
{

	for(unsigned i=0;i<m_pcRenderDataLst.Length();i++)
	{
		if(m_pcRenderDataLst[i])
		{
			delete m_pcRenderDataLst[i];m_pcRenderDataLst[i]=NULL;
		}
	}
}

void CModel::SetGroupCount(unsigned _nGroupCount)
{
	CleanUp();
	m_pcRenderDataLst.SetLength(_nGroupCount);
	for(unsigned i=0;i<m_pcRenderDataLst.Length();i++)
	{
		m_pcRenderDataLst[i]=NULL;
	}
}

void CModel::SetRenderData(unsigned _nIndex,CRenderData *pcData)
{
	ASSERT(_nIndex<m_pcRenderDataLst.Length(),"Incorrect Index:%d",_nIndex);
	ASSERT(m_pcRenderDataLst[_nIndex]==NULL,"RenderData already set");
	m_pcRenderDataLst[_nIndex]=pcData;
}
CRenderData	* CModel::GetRenderData(unsigned _nIndex)
{
	ASSERT(_nIndex<m_pcRenderDataLst.Length(),"Incorrect Index:%d",_nIndex);
	return m_pcRenderDataLst[_nIndex];
}
unsigned	 CModel::GetRenderDataCount()
{
	return m_pcRenderDataLst.Length();
}
void CModel::Render()
{
	unsigned i;
	for(i=0;i<m_pcRenderDataLst.Length();i++)
	{
		m_pcRenderDataLst[i]->RD_BeginRender();
		m_pcRenderDataLst[i]->RD_Render();
		m_pcRenderDataLst[i]->RD_EndRender();
	}
}
void CModel::RenderBoundingBox()
{
	Prims::RenderLineBox(m_cBoundingBox.getMin(),m_cBoundingBox.getMax());
}
