#include "Models/CModelUtils.hpp"
#include "Models/CRenderDataCollector.hpp"
#include "Materials/CMaterial.hpp"
#include "Utils/CVBOBuffer.h"
#include "Utils/MiscFuncs.hpp"

#include "ErrorCheck.h"


Indices::Indices()
{
	m_nNum=0;
	m_pcIndices=NULL;
}
Indices::~Indices()
{
	if(m_pcIndices)
	{
		delete []m_pcIndices;m_pcIndices=NULL;
		m_nNum=0;
	}
}
void	Indices::SetNum(unsigned _nNum)
{
	this->~Indices();
	m_nNum=_nNum;
	m_pcIndices=new Vertex[m_nNum];
}

Tris::Tris()
{
	m_nNum=0;
	m_pcTris=NULL;
}
Tris::~Tris()
{
	if(m_pcTris)
	{
		delete []m_pcTris;m_pcTris=NULL;
		m_nNum=0;
	}
}
void	Tris::SetNum(unsigned _nNum)
{
	this->~Tris();
	m_nNum=_nNum;
	m_pcTris=new STri[m_nNum];
}

///////////////////////////////////////////////////////////////
//Name:CRenderData
//Desc:
///////////////////////////////////////////////////////////////
CRenderData::CRenderData(const char *strName )
{
	m_pcMaterial = NULL;
	m_strName	 = NULL;
	strAllocNCopy(&m_strName,strName);


}
CRenderData::~CRenderData()
{
	free(m_strName);
	//Material is deleted by MaterialManger
}

void CRenderData::SetName(const char *strName)
{
	strAllocNCopy(&m_strName,strName);
}
void CRenderData::SetMaterial(CMaterial *pcMat)
{
	ASSERT(m_pcMaterial==NULL,"Material already set");
	m_pcMaterial=pcMat;
}
void CRenderData::AddDataToCollector(CRenderData *pcData)
{
	g_pcCollector->AddData(pcData);
}


///////////////////////////////////////////////////////////////
//Name:CRenderDataSimple
//Desc:
///////////////////////////////////////////////////////////////
CRenderDataSimple::CRenderDataSimple():CRenderData()
{
	m_eGeomType	 = GT_NONE;
	m_pcIndexLst = new Indices();
	m_pcTriLst	 = new Tris();
}
CRenderDataSimple::~CRenderDataSimple()
{
	delete m_pcIndexLst;
	delete m_pcTriLst;
}
void CRenderDataSimple::RD_BeginRender()
{
	m_pcMaterial->BeginUse();
}
void CRenderDataSimple::RD_Render()
{
	unsigned i,k,index;
	
	
	if(m_eGeomType==GT_TRIANGLES)
	{
		glBegin(GL_TRIANGLES);
		for( i=0;i<m_pcTriLst->GetNum();i++)
		{
			for(k=0;k<3;k++)
			{
				index=(*m_pcTriLst)[i].t[k];
				glColor3fv   ((*m_pcIndexLst)[index].m_vColor);
				glNormal3fv  ((*m_pcIndexLst)[index].m_vNormal);
				glTexCoord2fv((*m_pcIndexLst)[index].m_vUV);
				glVertex3fv  ((*m_pcIndexLst)[index].m_vVec);
			}
		}
		
		glEnd();
	}
	else if(m_eGeomType==GT_TRISTRIPS)
	{
		k=0;
		glBegin(GL_TRIANGLE_STRIP);
		for( i=0;i<m_pcTriLst->GetNum();i++)
		{
			{
				index=(*m_pcTriLst)[i].t[k];
				glColor3fv   ((*m_pcIndexLst)[index].m_vColor);
				glNormal3fv  ((*m_pcIndexLst)[index].m_vNormal);
				glTexCoord2fv((*m_pcIndexLst)[index].m_vUV);
				glVertex3fv  ((*m_pcIndexLst)[index].m_vVec);
			}
		}
		glEnd();
	}

	
	
	/*
	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
	glBegin(GL_LINES);
	glColor3f(1.0f,0.0f,0.0f);
	for( i=0;i<m_pcIndexLst->GetNum();i++)
	{

		glVertex3fv  ((*m_pcIndexLst)[i].m_vVec);
		glVertex3fv  ((*m_pcIndexLst)[i].m_vVec+(*m_pcIndexLst)[i].m_vNormal*50.0f);
		
	}
	glEnd();
	
	glEnable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);	
	*/
}
void CRenderDataSimple::RD_EndRender()
{
	m_pcMaterial->EndUse();
}
///////////////////////////////////////////////////////////////
//Name:CRenderDataVBO
//Desc:
///////////////////////////////////////////////////////////////

CRenderDataVBO::CRenderDataVBO():CRenderData()
{
	m_pcBuf=NULL;

}
CRenderDataVBO::~CRenderDataVBO()
{
	if(m_pcBuf)
	{
		delete m_pcBuf;m_pcBuf=NULL;
	}
}
void CRenderDataVBO::DeleteBuffer()
{
	if(m_pcBuf)
	{
		delete m_pcBuf;m_pcBuf=NULL;
	}
	else
	{
		DEBUGMSG("Buffer doesnt exists");
	}
}
void CRenderDataVBO::CreateBufferFromSimple(CRenderDataSimple *pcSimpleData)
{
	ASSERT(m_pcBuf==NULL,"Buffer already created");
	
	
	Tris		*pcTris=pcSimpleData->GetTriLst();
	Indices		*pcIndices=pcSimpleData->GetIndexLst();
	int			nElementCount;
	unsigned	i,k;
	unsigned	nIndex;



	SetName(pcSimpleData->GetName());
	switch(pcSimpleData->GetGeomType())
	{
	case CRenderDataSimple::GT_TRIANGLES:
		//DEBUGMSG("Using simple Triangles");
		nElementCount=pcTris->GetNum()*3;
		m_pcBuf=new CVBOBuffer(nElementCount,VSD_VERTEX|VSD_TEX0|VSD_NORMALS|VSD_COLORS,GL_TRIANGLES );

		m_pcBuf->SetDataStreamType(VSD_VERTEX,GL_DYNAMIC_DRAW_ARB);
		m_pcBuf->SetDataStreamType(VSD_NORMALS,GL_DYNAMIC_DRAW_ARB);
		m_pcBuf->SetDataStreamType(VSD_COLORS,GL_DYNAMIC_DRAW_ARB);
		for(i=0;i<pcTris->GetNum();i++)
		{
			for(k=0;k<3;k++)
			{
				nIndex=(*pcTris)[i].t[k];
				m_pcBuf->AddVertex((*pcIndices)[nIndex].m_vVec);
				m_pcBuf->AddNormal((*pcIndices)[nIndex].m_vNormal);
				m_pcBuf->AddTexCoord0((*pcIndices)[nIndex].m_vUV);
				Vector4D vColor=Vector4D(
					(*pcIndices)[nIndex].m_vColor.x,
					(*pcIndices)[nIndex].m_vColor.y,
					(*pcIndices)[nIndex].m_vColor.z,
					1.0f
				);
					
				m_pcBuf->AddColor(vColor);
			}

		}
		break;
	case CRenderDataSimple::GT_TRISTRIPS:
		nElementCount=pcTris->GetNum();
		m_pcBuf=new CVBOBuffer(pcIndices->GetNum(),VSD_VERTEX|VSD_TEX0|VSD_NORMALS|VSD_COLORS,GL_TRIANGLE_STRIP,true,nElementCount);
		m_pcBuf->SetDataStreamType(VSD_VERTEX,GL_DYNAMIC_DRAW_ARB);
		m_pcBuf->SetDataStreamType(VSD_NORMALS,GL_DYNAMIC_DRAW_ARB);
		for(i=0;i<pcIndices->GetNum();i++)
		{
			m_pcBuf->AddVertex((*pcIndices)[i].m_vVec);
			m_pcBuf->AddNormal((*pcIndices)[i].m_vNormal);
			m_pcBuf->AddTexCoord0((*pcIndices)[i].m_vUV);
			m_pcBuf->AddColor((*pcIndices)[i].m_vColor);
		}
		for(i=0;i<pcTris->GetNum();i++)
		{
			m_pcBuf->AddIndex((*pcTris)[i].t[0]);
		}
		
		/*
		for(i=0;i<pcTris->GetNum();i++)
		{
			nIndex=(*pcTris)[i].t[0];
			m_pcBuf->AddVertex((*pcIndices)[nIndex].m_vVec);
			m_pcBuf->AddNormal((*pcIndices)[nIndex].m_vNormal);
			m_pcBuf->AddTexCoord0((*pcIndices)[nIndex].m_vUV);
			m_pcBuf->AddColor((*pcIndices)[nIndex].m_vColor);
		}
		*/
		break;
	}
	m_pcBuf->BuildVBO();
	
	
}
void CRenderDataVBO::SetBuffer(CVBOBuffer *_pcBuf)
{
	ASSERT(m_pcBuf==NULL,"Buffer already Set");
	m_pcBuf=_pcBuf;
}
void CRenderDataVBO::RD_BeginRender()
{
	m_pcMaterial->BeginUse();
}
void CRenderDataVBO::RD_Render()
{	
	m_pcBuf->BeginRender();
	m_pcBuf->Render();
	m_pcBuf->EndRender();
}

void CRenderDataVBO::RD_EndRender()
{
	m_pcMaterial->EndUse();
}
