#include "Stdafx.h"
#include "Models/CRenderDataCollector.hpp"

#include "ErrorCheck.h"

CRDC *g_pcCollector=NULL;

CRDC::CRDC()
{
	//Allocate storage for 100 render data
	m_cRDList.SetLength(100);
	m_cRDList.SetLength(0);
}
CRDC::~CRDC()
{
}

void	CRDC::StartCollect()
{
	m_cRDList.SetLength(0);
}
void	CRDC::AddData(CRenderData *pcRenderData)
{
	m_cRDList.Add(pcRenderData);
}
void	CRDC::EndCollect()
{
}

void	CRDC::PrepareData()
{
}

void	CRDC::Render()
{
	ASSERT(m_cRDList.Length()<10000,"Too much objects , probably an error");
	//Little speed-up

	//If the same material is used, don't repeat bind again
	CMaterial *pcLastMat = NULL;
	unsigned i;
	for(i=0;i<m_cRDList.Length();i++)
	{
		if(pcLastMat!=m_cRDList[i]->GetMaterial() && pcLastMat!=NULL)
		{
			m_cRDList[i-1]->RD_EndRender();
			pcLastMat = NULL;
		}
		if(pcLastMat==NULL)
		{
			m_cRDList[i]->RD_BeginRender();
			pcLastMat = m_cRDList[i]->GetMaterial();

		}
		m_cRDList[i]->RD_Render();
	}
	if( pcLastMat!=NULL)
	{
		m_cRDList[i-1]->RD_EndRender();
		pcLastMat = NULL;
	}
}
unsigned CRDC::GetRenderableCount()
{
	return m_cRDList.Length();
}