#include "Models/CRenderObject.hpp"
#include "Camera/CFrustum.h"
#include "Primitives/MiscPrimitives.hpp"
#include "Animations/CAnimationPlayer.hpp"
#include "Models/CModel.hpp"
#include "Models/CModelUtils.hpp"
#include "Globals/Globals.hpp"

#include "ErrorCheck.h"


CRenderObject::CRenderObject(CModel *_pcModel)
{
	m_pcModel	   =_pcModel;
	m_cTransform   = Transform3D::getIdentity();
	m_vScale	   = Vector3D(1.0f,1.0f,1.0f);
	m_pcAnimPlayer = NULL;
	UpdateTransform();

}
CRenderObject::~CRenderObject()
{
}
void   CRenderObject::AttachAnimPlayer(CAnimationPlayer *pcPlayer)
{
	//ASSERT(m_pcAnimPlayer==NULL,"Animation Player already binded");
	m_pcAnimPlayer = pcPlayer;

	//For speed, renderobjects with the same model, animation data won't be 
	//generated, cause it'was already generated by last renderobject with same model
	if(m_pcAnimPlayer)m_pcAnimPlayer->GenerateAnimationData(this);
}

void   CRenderObject::SwitchToPlayer(CAnimationPlayer *pcPlayer)
{
	ASSERT(GetModel()==pcPlayer->GetBindedModel(),"Animation binded model doesn't match renderobject's");
	m_pcAnimPlayer = pcPlayer;
}
bool   CRenderObject::IsVisible()
{
	return g_cFrustum.BoxInFrustum(
		m_cTransformedBox.getMin(),
		m_cTransformedBox.getMax());
}
void   CRenderObject::Render()
{
	if(IsVisible())
	{
		glPushMatrix();
		
		glMultMatrixf(m_mOpenGl);

		glScalef(m_vScale.x,m_vScale.y,m_vScale.z);
		
		//If animation is attached to render object, make matrix every time
		CRenderData *pcCurrentRD;
		if(m_pcAnimPlayer)
		{
			
			for(unsigned i=0;i<m_pcModel->GetRenderDataCount();i++)
			{
				pcCurrentRD = m_pcModel->GetRenderData(i);
				
				glPushMatrix();

				m_pcAnimPlayer->SetMatrixForSubObject(i);
		
				pcCurrentRD->RD_BeginRender();
				pcCurrentRD->RD_Render();
				pcCurrentRD->RD_EndRender();

				glPopMatrix();
			}
		}
		else
		{
			for(unsigned i=0;i<m_pcModel->GetRenderDataCount();i++)
			{
				pcCurrentRD = m_pcModel->GetRenderData(i);
				
				glPushMatrix();
				glMultMatrixf(pcCurrentRD->GetInitialOpenGlMatrix());

				ShaderVals::g_vCurPosition = m_cTransform.v;
				ShaderVals::g_vCurScale	   = m_vScale;
				ShaderVals::g_mCurRotation = m_cTransform.m;

				pcCurrentRD->RD_BeginRender();
				pcCurrentRD->RD_Render();
				pcCurrentRD->RD_EndRender();
				glPopMatrix();
			}
		}
		glPopMatrix();
		//RenderBoundingBox();
	}
	
}

void   CRenderObject::RenderBoundingBox()
{
	Prims::RenderLineBox(m_cTransformedBox.getMin(),m_cTransformedBox.getMax());
}