#include "Models/Loaders/CTctLoader.hpp"
#include "Models/CModelUtils.hpp"
#include "Types/ExtArray.hpp"
#include "Managers/CTextureManager.hpp"
#include "Managers/CMaterialManager.hpp"
#include "Utils/CFileReader.hpp"
#include "Models/CModel.hpp"

#include "ErrorCheck.h"

CTctLoader g_cTctLoader; 

CTctLoader::CTctLoader()
{
}
CTctLoader::~CTctLoader()
{
}
CModel * CTctLoader::LoadModel(const char *strFile)
{
	char			   buf[255];
	unsigned		   i,j,k;
	int				   nGeomType;

	CFileReader		   cFile;
	
	if(cFile.OpenFile(strFile))
	{
		cFile.ReadString(buf,sizeof(buf));
		if(strcmp(buf,"TCT")!=0)
		{	
			DEBUGMSG("This is not a Tct File");
			cFile.CloseFile();
			return NULL;
		}
		if(cFile.ReadInt32()!=101)
		{
			DEBUGMSG("Incorrect version");
			cFile.CloseFile();
			return NULL;
		}
		
		//0 - Triangles
		//1 - Tri Strips
		nGeomType=cFile.ReadInt32();
		
		//Initial data
		CModel			  *pcResult		   = new CModel(strFile);
		unsigned		   nGroupCount=0;
		unsigned		   nIndicesCount=0;
		unsigned		   nFaceCount=0;
		unsigned		   nMatCount;
		
	
		
		//Materials
		nMatCount=cFile.ReadUint32();

		
		//Geometry
		nGroupCount=cFile.ReadUint32();
		
		
		pcResult->SetGroupCount(nGroupCount);
		for(i=0;i<nGroupCount;i++)
		{
			CRenderDataSimple *pcTmpData=new CRenderDataSimple();
			
			
			//Delete it , for debug only !!!
			//pcResult->SetRenderData(i,pcTmpData);
			pcResult->SetRenderData(i,new CRenderDataVBO());
			
			
			pcTmpData->SetGeomType(CRenderDataSimple::EGeometryType(nGeomType));
			cFile.ReadString(buf,sizeof(buf));
			pcTmpData->SetName(buf);

			//Read Initial transform
			Transform3D tTrans;
			for(int u=0;u<3;u++)
			{
				tTrans.m[u][0] = cFile.ReadFloat32();
				tTrans.m[u][1] = cFile.ReadFloat32();
				tTrans.m[u][2] = cFile.ReadFloat32();
			}
			tTrans.m.transpose();
			tTrans.v = cFile.ReadVector3D();

			pcResult->GetRenderData(i)->SetInitialTransform(tTrans);
			
			nIndicesCount=cFile.ReadUint32();
			Indices *pcCurInd=pcTmpData->GetIndexLst();
			pcCurInd->SetNum(nIndicesCount);

			//Temporary bounding box for sub-object
			BoundingBox bTempBox;
			for(j=0;j<nIndicesCount;j++)
			{
				(*pcCurInd)[j].m_vVec = cFile.ReadVector3D();

				(*pcCurInd)[j].m_vUV	= cFile.ReadVector2D();
				(*pcCurInd)[j].m_vColor	= cFile.ReadVector4D();
				(*pcCurInd)[j].m_vNormal= cFile.ReadVector3D();
			
				bTempBox.addVertex(tTrans.transformPoint((*pcCurInd)[j].m_vVec));
			}
			//Attach it to the hole bounding box
			pcResult->GetBoundingBox().merge(bTempBox);
			
			
			
			nFaceCount=cFile.ReadUint32();
			Tris *pcCurTri=pcTmpData->GetTriLst();
			pcCurTri->SetNum(nFaceCount);
			switch (nGeomType)
			{
			//Triangles
			case 0:
				for(j=0;j<nFaceCount;j++)
				{
					for(k=0;k<3;k++)
					{
						(*pcCurTri)[j].t[k]	= cFile.ReadUint32();
						ASSERT((*pcCurTri)[j].t[k]<nIndicesCount,"Incorrect Face Index %d",(*pcCurTri)[j].t[k]);

					}	
				}
				break;
			//Tri Strips
			case 1:
				for(j=0;j<nFaceCount;j++)
				{
					(*pcCurTri)[j].t[0]	= cFile.ReadUint32();
					ASSERT((*pcCurTri)[j].t[0]<nIndicesCount,"Incorrect Face Index %d",(*pcCurTri)[j].t[0]);	
				}
				break;
				

			}
			cFile.ReadString(buf,sizeof(buf));
			pcResult->GetRenderData(i)->SetMaterial(g_pcMatMan->LoadTctMaterial(buf));
			
			//Get Current RenderVBO and fill it with data
			((CRenderDataVBO*)pcResult->GetRenderData(i))->CreateBufferFromSimple(pcTmpData);;
			
			
					
			delete pcTmpData;
		}
		
		cFile.CloseFile();
		return pcResult;
	}
	else
	{
		DEBUGMSG("File %s not found",strFile);
	}




	return NULL;
	
}