#include "Stdafx.h"
#include "Props/CAttribute.hpp"
#include "Utils/MiscFuncs.hpp"

#include "ErrorCheck.h"



CAttribute::CAttribute(const char *strName,const char *strValue)
:m_eValueType(VT_STRING)
{
	ASSERT(strlen(strValue)<50,"Value length is too big:%d",strlen(strValue));
	InitData(strName);
	strcpy_s(m_uValue.strValue,strValue);

}
CAttribute::CAttribute(const char *strName,float		  fValue)
:m_eValueType(VT_FLOAT)
{
	InitData(strName);
	m_uValue.fValue = fValue;
}
CAttribute::CAttribute(const char *strName,int		  iValue)
:m_eValueType(VT_INT)
{
	InitData(strName);
	m_uValue.iValue = iValue;
}
CAttribute::CAttribute(const char *strName,short		  nValue)
:m_eValueType(VT_SHORT)
{
	InitData(strName);
	m_uValue.nValue = nValue;
}
CAttribute::CAttribute(const char *strName,bool		  bValue)
:m_eValueType(VT_BOOL)
{
	InitData(strName);
	m_uValue.bValue = bValue;
}
CAttribute::CAttribute(const char *strName,const Vector2D& vValue2D)
:m_eValueType(VT_VEC2)
{
	InitData(strName);
	m_uValue.vValue2D[0] = vValue2D.x;
	m_uValue.vValue2D[1] = vValue2D.y;
}
CAttribute::CAttribute(const char *strName,const Vector3D& vValue3D)
:m_eValueType(VT_VEC3)
{
	InitData(strName);
	m_uValue.vValue3D[0] = vValue3D.x;
	m_uValue.vValue3D[1] = vValue3D.y;
	m_uValue.vValue3D[2] = vValue3D.z;
}
CAttribute::CAttribute(const char *strName,const Vector4D& vValue4D)
{
	InitData(strName);
	m_uValue.vValue4D[0] = vValue4D.x;
	m_uValue.vValue4D[1] = vValue4D.y;
	m_uValue.vValue4D[2] = vValue4D.z;
	m_uValue.vValue4D[3] = vValue4D.w;
}
CAttribute::CAttribute(const char *strName,const Matrix3D& mValue3)
:m_eValueType(VT_MAT3)
{
	InitData(strName);
	m_uValue.mValue3[0][0] = mValue3[0][0];
	m_uValue.mValue3[0][1] = mValue3[0][1];
	m_uValue.mValue3[0][2] = mValue3[0][2];

	m_uValue.mValue3[1][0] = mValue3[1][0];
	m_uValue.mValue3[1][1] = mValue3[1][1];
	m_uValue.mValue3[1][2] = mValue3[1][2];

	m_uValue.mValue3[2][0] = mValue3[2][0];
	m_uValue.mValue3[2][1] = mValue3[2][1];
	m_uValue.mValue3[2][2] = mValue3[2][2];
}
CAttribute::CAttribute(const char *strName,const Matrix4D& mValue4)
:m_eValueType(VT_MAT4)
{
	InitData(strName);
	m_uValue.mValue4[0][0] = mValue4[0][0];
	m_uValue.mValue4[0][1] = mValue4[0][1];
	m_uValue.mValue4[0][2] = mValue4[0][2];
	m_uValue.mValue4[0][3] = mValue4[0][3];

	m_uValue.mValue4[1][0] = mValue4[1][0];
	m_uValue.mValue4[1][1] = mValue4[1][1];
	m_uValue.mValue4[1][2] = mValue4[1][2];
	m_uValue.mValue4[1][3] = mValue4[1][3];

	m_uValue.mValue4[2][0] = mValue4[2][0];
	m_uValue.mValue4[2][1] = mValue4[2][1];
	m_uValue.mValue4[2][2] = mValue4[2][2];
	m_uValue.mValue4[2][3] = mValue4[2][3];

	m_uValue.mValue4[3][0] = mValue4[3][0];
	m_uValue.mValue4[3][1] = mValue4[3][1];
	m_uValue.mValue4[3][2] = mValue4[3][2];
	m_uValue.mValue4[3][3] = mValue4[3][3];
}
CAttribute::~CAttribute()
{
	free(m_strName);
}
void	CAttribute::InitData(const char *strName)
{
	m_strName = NULL;
	strAllocNCopy(&m_strName , strName);
	SetFloatPrecision(4);
}

void		 CAttribute::SetFloatPrecision(unsigned nFloatPrecision)
{
	sprintf_s(m_strFloatFormat,50,"%%.%df",nFloatPrecision);
	sprintf_s(m_strVec2Format,50,"%%.%df;%%.%df",nFloatPrecision,nFloatPrecision);
	sprintf_s(m_strVec3Format,50,"%%.%df;%%.%df;%%.%df",nFloatPrecision,nFloatPrecision,nFloatPrecision);
	sprintf_s(m_strVec4Format,50,"%%.%df;%%.%df;%%.%df;%%.%df",nFloatPrecision,nFloatPrecision,nFloatPrecision,nFloatPrecision);
	sprintf_s(m_strMat3Format,100,"%%.%df;%%.%df;%%.%df;%%.%df;%%.%df;%%.%df;%%.%df;%%.%df;%%.%df",
		nFloatPrecision,nFloatPrecision,nFloatPrecision,
		nFloatPrecision,nFloatPrecision,nFloatPrecision,
		nFloatPrecision,nFloatPrecision,nFloatPrecision);
	sprintf_s(m_strMat4Format,100,"%%.%df;%%.%df;%%.%df;%%.%df;%%.%df;%%.%df;%%.%df;%%.%df;%%.%df;%%.%df;%%.%df;%%.%df;%%.%df;%%.%df;%%.%df;%%.%df",
		nFloatPrecision,nFloatPrecision,nFloatPrecision,nFloatPrecision,
		nFloatPrecision,nFloatPrecision,nFloatPrecision,nFloatPrecision,
		nFloatPrecision,nFloatPrecision,nFloatPrecision,nFloatPrecision,
		nFloatPrecision,nFloatPrecision,nFloatPrecision,nFloatPrecision);
}

void			CAttribute::SetName(const char *strName)
{
	strAllocNCopy(&m_strName , strName);
}
const char *	CAttribute::ConvertToString()
{
	switch(m_eValueType)
	{
	case VT_UNDEFINED:
		FATALERROR("Value is undefined");
		break;
	case VT_STRING:
		//Do nothing
		break;
	case VT_FLOAT:
		sprintf_s(m_uValue.strValue,m_cnValStrLen,m_strFloatFormat,m_uValue.fValue);
		break;
	case VT_INT:
		sprintf_s(m_uValue.strValue,m_cnValStrLen,"%d",m_uValue.iValue);
		break;
	case VT_SHORT:
		sprintf_s(m_uValue.strValue,m_cnValStrLen,"%d",m_uValue.nValue);
		break;
	case VT_BOOL:
		sprintf_s(m_uValue.strValue,m_cnValStrLen,"%s",m_uValue.bValue?"True":"False");
		break;
	case VT_VEC2:
		sprintf_s(m_uValue.strValue,m_cnValStrLen,m_strVec2Format,m_uValue.vValue2D[0],m_uValue.vValue2D[1]);
		break;
	case VT_VEC3:
		sprintf_s(m_uValue.strValue,m_cnValStrLen,m_strVec3Format,m_uValue.vValue3D[0],m_uValue.vValue3D[1],m_uValue.vValue3D[2]);
		break;
	case VT_MAT3:
		sprintf_s(m_uValue.strValue,m_cnValStrLen,m_strMat3Format,
			m_uValue.mValue3[0][0],m_uValue.mValue3[1][0],m_uValue.mValue3[2][0],
			m_uValue.mValue3[0][1],m_uValue.mValue3[1][1],m_uValue.mValue3[2][1],
			m_uValue.mValue3[0][2],m_uValue.mValue3[1][2],m_uValue.mValue3[2][2]);
		break;
	case VT_MAT4:
		sprintf_s(m_uValue.strValue,m_cnValStrLen,m_strMat4Format,
			m_uValue.mValue3[0][0],m_uValue.mValue3[1][0],m_uValue.mValue3[2][0],m_uValue.mValue3[3][0],
			m_uValue.mValue3[0][1],m_uValue.mValue3[1][1],m_uValue.mValue3[2][1],m_uValue.mValue3[3][1],
			m_uValue.mValue3[0][2],m_uValue.mValue3[1][2],m_uValue.mValue3[2][2],m_uValue.mValue3[3][2],
			m_uValue.mValue3[0][3],m_uValue.mValue3[1][3],m_uValue.mValue3[2][3],m_uValue.mValue3[3][3]);
		break;
	default:
		FATALERROR("Conversion not implemented");
	}
	//Conversion successful
	m_eValueType = VT_STRING;
	return m_uValue.strValue;
	
}
//Property can be converted, if it was a string
float	CAttribute::ConvertToFloat()
{
	ASSERT(m_eValueType==VT_STRING,"Can convert only strings");
	m_eValueType = VT_FLOAT;

	m_uValue.fValue = atof(m_uValue.strValue);
	return m_uValue.fValue;
}
int		CAttribute::ConvertToInt()
{
	ASSERT(m_eValueType==VT_STRING,"Can convert only strings");
	m_eValueType = VT_INT;

	m_uValue.iValue = atoi(m_uValue.strValue);
	return m_uValue.iValue;
}
short	CAttribute::ConvertToShort()
{
	ASSERT(m_eValueType==VT_STRING,"Can convert only strings");
	m_eValueType = VT_SHORT;

	m_uValue.nValue = atoi(m_uValue.strValue);
	return m_uValue.nValue;
}
bool	CAttribute::ConvertToBool()
{
	ASSERT(m_eValueType==VT_STRING,"Can convert only strings");
	m_eValueType = VT_BOOL;

	m_uValue.bValue = (_strcmpi(m_uValue.strValue,"True")==0);
	return m_uValue.bValue;
}
Vector2D CAttribute::ConvertToVector2D()
{
	ASSERT(m_eValueType==VT_STRING,"Can convert only strings");
	m_eValueType = VT_VEC2;

	//We must make a copy of string, cause strtok will fail in process(cause the string is going to change)
	char strTempString[m_cnValStrLen];
	strcpy_s(strTempString,m_cnValStrLen,m_uValue.strValue);

	char *tmp,*next;
	for(int i=0;i<2;i++)
	{
		next = strtok_s(i==0?strTempString:NULL,";",&tmp);
		ASSERT(next!=NULL,"Failed conversion to vector2D on symbol:%d",i);
		m_uValue.vValue2D[i] = atof(next);
	}

	return Vector2D(m_uValue.vValue2D[0],m_uValue.vValue2D[1]);
}
Vector3D CAttribute::ConvertToVector3D()
{
	ASSERT(m_eValueType==VT_STRING,"Can convert only strings");
	m_eValueType = VT_VEC3;

	char strTempString[m_cnValStrLen];
	strcpy_s(strTempString,m_cnValStrLen,m_uValue.strValue);

	char *tmp,*next;
	for(int i=0;i<3;i++)
	{
		next = strtok_s(i==0?strTempString:NULL,";",&tmp);
		ASSERT(next!=NULL,"Failed conversion to vector3D on symbol:%d",i);
		m_uValue.vValue3D[i] = atof(next);
	}
	return Vector3D(m_uValue.vValue3D[0],m_uValue.vValue3D[1],m_uValue.vValue3D[2]);
}
Vector4D CAttribute::ConvertToVector4D()
{
	ASSERT(m_eValueType==VT_STRING,"Can convert only strings");
	m_eValueType = VT_VEC4;

	char strTempString[m_cnValStrLen];
	strcpy_s(strTempString,m_cnValStrLen,m_uValue.strValue);

	char *tmp,*next;
	for(int i=0;i<4;i++)
	{
		next = strtok_s(i==0?strTempString:NULL,";",&tmp);
		ASSERT(next!=NULL,"Failed conversion to vector3D on symbol:%d",i);
		m_uValue.vValue4D[i] = atof(next);
	}
	return Vector4D(m_uValue.vValue4D[0],m_uValue.vValue4D[1],m_uValue.vValue4D[2],m_uValue.vValue4D[3]);
}
Matrix3D CAttribute::ConvertToMatrix3D()
{
	ASSERT(m_eValueType==VT_STRING,"Can convert only strings");
	m_eValueType = VT_MAT3;

	char strTempString[m_cnValStrLen];
	strcpy_s(strTempString,m_cnValStrLen,m_uValue.strValue);

	Matrix3D m;
	char *tmp,*next;
	for(int y=0;y<3;y++)
	{
		for(int x=0;x<3;x++)
		{
			next = strtok_s((x==0 && y==0)?strTempString:NULL,";",&tmp);
			ASSERT(next!=NULL,"Failed conversion to mat3 on symbol:(%d,%d)",x,y);
			m[x][y] = m_uValue.mValue3[x][y] = atof(next);
		}
	}
	return m;
}
Matrix4D CAttribute::ConvertToMatrix4D()
{
	ASSERT(m_eValueType==VT_STRING,"Can convert only strings");
	m_eValueType = VT_MAT4;

	char strTempString[m_cnValStrLen];
	strcpy_s(strTempString,m_cnValStrLen,m_uValue.strValue);

	Matrix4D m;
	char *tmp,*next;
	for(int y=0;y<4;y++)
	{
		for(int x=0;x<4;x++)
		{
			next = strtok_s((x==0 && y==0)?strTempString:NULL,";",&tmp);
			ASSERT(next!=NULL,"Failed conversion to mat4 on symbol:(%d,%d)",x,y);
			m[x][y] = m_uValue.mValue4[x][y] = atof(next);
		}
	}
	return m;
}





const char *CAttribute::GetString()const
{
	ASSERT(m_eValueType==VT_STRING,"Not a string");
	return m_uValue.strValue;
}
float			CAttribute::GetFloat()const
{
	ASSERT(m_eValueType==VT_FLOAT,"Not a float");
	return m_uValue.fValue;
}
int		CAttribute::GetInt()const
{
	ASSERT(m_eValueType==VT_INT,"Not a int");
	return m_uValue.iValue;
}
short	CAttribute::GetShort()const
{
	ASSERT(m_eValueType==VT_SHORT,"Not a short");
	return m_uValue.nValue;

}
bool	CAttribute::GetBool()const
{
	ASSERT(m_eValueType==VT_BOOL,"Not a bool");
	return m_uValue.bValue;

}
Vector2D CAttribute::GetVector2D()const
{
	ASSERT(m_eValueType==VT_VEC2,"Not a vector2D");
	return Vector2D(m_uValue.vValue2D[0],m_uValue.vValue2D[1]);
}
Vector3D CAttribute::GetVector3D()const
{
	ASSERT(m_eValueType==VT_VEC3,"Not a vector3D");
	return Vector3D(m_uValue.vValue3D[0],m_uValue.vValue3D[1],m_uValue.vValue3D[2]);
}
Vector4D CAttribute::GetVector4D()const
{
	ASSERT(m_eValueType==VT_VEC4,"Not a vector4D");
	return Vector4D(m_uValue.vValue4D[0],m_uValue.vValue4D[1],m_uValue.vValue4D[2],m_uValue.vValue4D[3]);
}
Matrix3D CAttribute::GetMatrix3D()const
{
	ASSERT(m_eValueType==VT_MAT3,"Not a matrix3D");

	Matrix3D m;
	m[0][0] = m_uValue.mValue3[0][0];
	m[0][1] = m_uValue.mValue3[0][1];
	m[0][2] = m_uValue.mValue3[0][2];

	m[1][0] = m_uValue.mValue3[1][0];
	m[1][1] = m_uValue.mValue3[1][1];
	m[1][2] = m_uValue.mValue3[1][2];

	m[2][0] = m_uValue.mValue3[2][0];
	m[2][1] = m_uValue.mValue3[2][1];
	m[2][2] = m_uValue.mValue3[2][2];
	return m;

}
Matrix4D CAttribute::GetMatrix4D()const
{
	ASSERT(m_eValueType==VT_MAT4,"Not a matrix4D");

	Matrix4D m;

	m[0][0] = m_uValue.mValue4[0][0];
	m[0][1] = m_uValue.mValue4[0][1];
	m[0][2] = m_uValue.mValue4[0][2];
	m[0][3] = m_uValue.mValue4[0][3];

	m[1][0] = m_uValue.mValue4[1][0];
	m[1][1] = m_uValue.mValue4[1][1];
	m[1][2] = m_uValue.mValue4[1][2];
	m[1][3] = m_uValue.mValue4[1][3];

	m[2][0] = m_uValue.mValue4[2][0];
	m[2][1] = m_uValue.mValue4[2][1];
	m[2][2] = m_uValue.mValue4[2][2];
	m[2][3] = m_uValue.mValue4[2][3];

	m[3][0] = m_uValue.mValue4[3][0];
	m[3][1] = m_uValue.mValue4[3][1]; 
	m[3][2] = m_uValue.mValue4[3][2];
	m[3][3] = m_uValue.mValue4[3][3];
	return m;

}

void	CAttribute::SetString(const char *strValue)
{
	ASSERT(strlen(strValue)<m_cnValStrLen,"Value length is too big:%d",strlen(strValue));
	m_eValueType = VT_STRING;
	strcpy_s(m_uValue.strValue,strValue);
}
void	CAttribute::SetFloat(float		  fValue)
{
	m_eValueType = VT_FLOAT;
	m_uValue.fValue=fValue;
}
void	CAttribute::SetInt(int		  iValue)
{
	m_eValueType = VT_INT;
	m_uValue.iValue=iValue;
}
void	CAttribute::SetShort(short		  nValue)
{
	m_eValueType = VT_SHORT;
	m_uValue.nValue=nValue;
}
void	CAttribute::SetBool(bool		  bValue)
{
	m_eValueType = VT_BOOL;
	m_uValue.bValue=bValue;
}
void	CAttribute::SetVector2D(const Vector2D& vValue2D)
{
	m_eValueType = VT_VEC2;
	m_uValue.vValue2D[0] = vValue2D.x;
	m_uValue.vValue2D[1] = vValue2D.y;
}
void	CAttribute::SetVector3D(const Vector3D& vValue3D)
{
	m_eValueType = VT_VEC3;
	m_uValue.vValue3D[0] = vValue3D.x;
	m_uValue.vValue3D[1] = vValue3D.y;
	m_uValue.vValue3D[2] = vValue3D.z;
}
void	CAttribute::SetVector4D(const Vector4D& vValue4D)
{
	m_eValueType = VT_VEC3;
	m_uValue.vValue4D[0] = vValue4D.x;
	m_uValue.vValue4D[1] = vValue4D.y;
	m_uValue.vValue4D[2] = vValue4D.z;
	m_uValue.vValue4D[3] = vValue4D.w;
}
void	CAttribute::SetMatrix3D(const Matrix3D& mValue3)
{
	m_eValueType = VT_MAT3;
	m_uValue.mValue3[0][0] = mValue3[0][0];
	m_uValue.mValue3[0][1] = mValue3[0][1];
	m_uValue.mValue3[0][2] = mValue3[0][2];

	m_uValue.mValue3[1][0] = mValue3[1][0];
	m_uValue.mValue3[1][1] = mValue3[1][1];
	m_uValue.mValue3[1][2] = mValue3[1][2];

	m_uValue.mValue3[2][0] = mValue3[2][0];
	m_uValue.mValue3[2][1] = mValue3[2][1];
	m_uValue.mValue3[2][2] = mValue3[2][2];
}
void	CAttribute::SetMatrix4D(const Matrix4D& mValue4)
{
	m_eValueType = VT_MAT4;
	
	m_uValue.mValue4[0][0] = mValue4[0][0];
	m_uValue.mValue4[0][1] = mValue4[0][1];
	m_uValue.mValue4[0][2] = mValue4[0][2];
	m_uValue.mValue4[0][3] = mValue4[0][3];

	m_uValue.mValue4[1][0] = mValue4[1][0];
	m_uValue.mValue4[1][1] = mValue4[1][1];
	m_uValue.mValue4[1][2] = mValue4[1][2];
	m_uValue.mValue4[1][3] = mValue4[1][3];

	m_uValue.mValue4[2][0] = mValue4[2][0];
	m_uValue.mValue4[2][1] = mValue4[2][1];
	m_uValue.mValue4[2][2] = mValue4[2][2];
	m_uValue.mValue4[2][3] = mValue4[2][3];

	m_uValue.mValue4[3][0] = mValue4[3][0];
	m_uValue.mValue4[3][1] = mValue4[3][1];
	m_uValue.mValue4[3][2] = mValue4[3][2];
	m_uValue.mValue4[3][3] = mValue4[3][3];
}