#include "Stdafx.h"
#include "Props/CAttributeGroup.hpp"
#include "Props/CAttribute.hpp"
#include "Utils/MiscFuncs.hpp"

#include "ErrorCheck.h"

CAttributeGroup::CAttributeGroup(const char* strName)
{
	m_strName = NULL;
	strAllocNCopy(&m_strName,strName);
}
CAttributeGroup::~CAttributeGroup()
{
	free(m_strName);
	Clear();	
}
void	CAttributeGroup::Clear()
{
	m_pcAttrs.ClearData();
	m_pcAttrs.Clear();
}
unsigned	CAttributeGroup::Count()
{
	return m_pcAttrs.Count();
}
bool	CAttributeGroup::AddAttribute(CAttribute *pcNewAttr)
{
	if(m_pcAttrs.Find(pcNewAttr->GetName())==NULL)
	{
		m_pcAttrs.Add(pcNewAttr->GetName(), pcNewAttr);
		return true;
	}
	else
	{
		DEBUGMSG("Attribute %s was already loaded, not adding...",pcNewAttr->GetName());
		return false;
	}
	
}
bool	CAttributeGroup::RemoveAttribute(CAttribute *pcNewAttr)
{
	m_pcAttrs.Remove(pcNewAttr->GetName());
	return true;
}
bool	CAttributeGroup::RemoveAttribute(const char *strName)
{
	m_pcAttrs.Remove(strName);
	return true;
}	

CAttribute * CAttributeGroup::FindAttribute(const char *strName)
{
	HashItem<CAttribute*> *pcItem = m_pcAttrs.Find(strName);
	ASSERT(pcItem!=NULL,"Failed to find attribute %s in group %s",strName,m_strName);
	return pcItem!=NULL?pcItem->data:NULL;
}
HashItem<CAttribute*> *CAttributeGroup::GetNextAttribute(HashItem<CAttribute*> *pcItem)
{
	return m_pcAttrs.Next(pcItem);
}