#include "Stdafx.h"
#include "Props/CProperties.hpp"
#include "Props/CAttributeGroup.hpp"

#include "ErrorCheck.h"

CProperties::CProperties()
{

}
CProperties::~CProperties()
{
	Clear();	
}
void	CProperties::Clear()
{
	m_pcProps.ClearData();
	m_pcProps.Clear();
}
unsigned	CProperties::Count()
{
	return m_pcProps.Count();
}
bool	CProperties::AddAttrGroup(CAttributeGroup *pcNewProp)
{
	if(m_pcProps.Find(pcNewProp->GetName())==NULL)
	{
		m_pcProps.Add(pcNewProp->GetName(), pcNewProp);
		return true;
	}
	else
	{
		DEBUGMSG("Attribute Group %s was already loaded, not adding...",pcNewProp->GetName());
		return false;
	}
	
}
bool	CProperties::RemoveAttrGroup(CAttributeGroup *pcProp)
{
	m_pcProps.Remove(pcProp->GetName());
	return true;
}
bool	CProperties::RemoveAttrGroup(const char *strName)
{
	m_pcProps.Remove(strName);
	return true;
}	

CAttributeGroup * CProperties::FindAttrGroup(const char *strName)
{
	HashItem<CAttributeGroup*> *pcItem = m_pcProps.Find(strName);
	ASSERT(pcItem!=NULL,"Failed to find attribute group:%s",strName);
	return pcItem!=NULL?pcItem->data:NULL;
}
HashItem<CAttributeGroup*> *CProperties::GetNextAttrGroup(HashItem<CAttributeGroup*> *pcItem)
{
	return m_pcProps.Next(pcItem);
}