#include "Utils/CFileReader.hpp"
#include "Stdafx.h"
#include "Globals/Globals.hpp"


#include "Utils/MiscMacros.hpp"

#include "ErrorCheck.h"

CFileReader::CFileReader()
{
	m_pcBuffer = NULL;

	m_nCurPtr = 0;
	m_nSize = 0;
}
CFileReader::~CFileReader()
{
	ASSERT(m_pcBuffer==NULL,"File buffer wasn't deleted");
	SAFE_DELETE_ARRAY(m_pcBuffer);
	
}

bool CFileReader::OpenFile(const char *strName)
{
	
	FILE *fp;
	if(strstr(strName,g_sApp.strMainDir)==NULL)
	{
		char buf[1024];
		sprintf_s(buf,"%s\\%s",g_sApp.strMainDir,strName);
		fp = fopen(buf,"rb");
	}
	else
	{
		fp = fopen(strName,"rb");
	}



	
	if(fp)
	{
		fseek (fp, 0, SEEK_END);
		m_nSize = ftell (fp);
		fseek (fp, 0, SEEK_SET);

		m_pcBuffer = new unsigned char[m_nSize];

		fread(m_pcBuffer,sizeof(unsigned char)*m_nSize,1,fp);

		fclose(fp);
		m_nCurPtr = 0;
		return true;
	}
	else return false;
}
void CFileReader::CloseFile()
{
	ASSERT(m_pcBuffer!=NULL,"CloseFile() was called, but no file was opened");
	SAFE_DELETE_ARRAY(m_pcBuffer);
	m_nSize = m_nCurPtr = 0;
}

