#include "Utils/CKeys.h"

CKeys g_cKeys;

CKeys::CKeys()
{
	int i;
	for(i=0;i<256;i++)
	{
		m_bLastKeys[i]=m_bKeys[i]=false;
	}
	m_bPressed=false;
	m_nPressedID=0;
}
void	CKeys::PressedKey(BYTE nKeyID)
{
	m_bKeys[nKeyID]=true;
	m_nPressedID=nKeyID;
	m_bPressed=true;
}
void	CKeys::UnPressedKey(BYTE nKeyID)
{
	m_bKeys[nKeyID]=false;
	m_bPressed=true;
}

bool	CKeys::GetKey(BYTE nKeyID)
{
	return m_bKeys[nKeyID];

}
bool	CKeys::Changed(BYTE nKeyID)
{
	return m_bKeys[nKeyID]!=m_bLastKeys[nKeyID];

}
BYTE    CKeys::GetLastPressed()
{
	return m_nPressedID;

}
void	CKeys::Update()
{
	if(m_bPressed)
	{
		for(int i=0;i<256;i++)
		{
			m_bLastKeys[i]=m_bKeys[i];
		}
		m_bPressed=false;

	}

}