#include "Utils/CMiscCollisions.hpp"

const float nMinDist = 1e10;


bool FindTriLineCollision(Vector3D vTr0,Vector3D vTr1,Vector3D vTr2,
                          Vector3D vL0 ,Vector3D vL1 ,Vector3D &c,Vector3D &n,bool bSkipBack)
{
	Vector3D rayOrg=vL0;
	Vector3D rayDelta=vL1-vL0;
	
   
    Vector3D e1=vTr1-vTr0;
    Vector3D e2=vTr2-vTr1;
    
	n = Cross(e1,e2);
	
	float dot=Dot(n,rayDelta);
	
	if(!(dot<0.0f))
		return false;
		
	float d=Dot(n,vTr0);
	
	float t=d-Dot(n,rayOrg);
	
	if(!(t<=0.0f))
		return false;
	
	if(!(t>=dot))
		return false;
		
	t/=dot;
	
	Vector3D p=rayOrg+rayDelta*t;
	
	float u0,u1,u2;
	float v0,v1,v2;
	
	if(fabsf(n.x)>fabsf(n.y))
	{
		if(fabsf(n.x)>fabsf(n.z))
		{
			u0 = p.y    - vTr0.y;
			u1 = vTr1.y - vTr0.y;
			u2 = vTr2.y - vTr0.y;
			
			v0 = p.z    - vTr0.z;
			v1 = vTr1.z - vTr0.z;
			v2 = vTr2.z - vTr0.z;
		}
		else
		{
			u0 = p.x    - vTr0.x;
			u1 = vTr1.x - vTr0.x;
			u2 = vTr2.x - vTr0.x;
			
			v0 = p.y    - vTr0.y;
			v1 = vTr1.y - vTr0.y;
			v2 = vTr2.y - vTr0.y;
		}
	}
	else
	{
		if(fabsf(n.y)>fabsf(n.z))
		{
			u0 = p.x    - vTr0.x;
			u1 = vTr1.x - vTr0.x;
			u2 = vTr2.x - vTr0.x;
			
			v0 = p.z    - vTr0.z;
			v1 = vTr1.z - vTr0.z;
			v2 = vTr2.z - vTr0.z;
		}
		else
		{
			u0 = p.x    - vTr0.x;
			u1 = vTr1.x - vTr0.x;
			u2 = vTr2.x - vTr0.x;
			
			v0 = p.y    - vTr0.y;
			v1 = vTr1.y - vTr0.y;
			v2 = vTr2.y - vTr0.y;
		}
	}
	
	
	float temp = u1*v2 - v1*u2;
	
	if(!(temp!=0.0f))
		return false;

	
	temp = 1.0f/temp;
	
	float alpha = (u0 * v2 - v0*u2)*temp;
	
	if(!(alpha>=0.0f))
		return false;
	
	float beta = (u1*v0 - v1*u0)*temp;
	
	if(!(beta>=0.0f))
		return false;
		
	float gamma= 1.0f - alpha - beta;
	
	if(!(gamma>=0.0f))
		return false;
		
		
	n.normalize();
	c=vL0+t*rayDelta;
	return true;
	
	
	
    
    

    
}
bool FindRayTriCollision(const Vector3D& vP0,
						 const Vector3D& vP1,
						 const Vector3D& vP2,
						 const Vector3D& vOrg,
						 const Vector3D& vDir,
						 Vector3D& vResult,
						 Vector3D& vNormal,
						 float &fOmega,
						 float &fDelta,
						 float fEps )
{

	Vector3D d1 = vP1 - vP0;
	Vector3D d2 = vP2 - vP0;
	vNormal		= Cross(d1,d2);
	fOmega = Dot(-vDir,vNormal);
	//Check if ray is not parallel to tri plane
	if(fabsf(fOmega)>fEps)
	{
		Vector3D b = vOrg - vP0;
		fDelta = Dot(b,vNormal)/fOmega;

		//if fDelta is outside (fDelta<0.0f or fDelta>1.0f)
		//The collision is outside [vOrg,vOrg + vDir]
		
		Vector3D u	   = Cross(b,vDir);
		float	 fMiu1 = Dot(d2,u)/fOmega;
		float	 fMiu2 = Dot(-d1,u)/fOmega;
		//Check if ray is outside tri
		if(fMiu1+fMiu2<=1.0f && fMiu1>=0.0f && fMiu2>=0.0f)
		{
			vResult = vOrg + fDelta*vDir;
			return true;
		}
		else 
		{
			return false;
		}
	}
	else
	{
		return false;
	}
}


/*
void FindNormalAndDistance(Vector3D vTr0,Vector3D vTr1,Vector3D vTr2,Vector3D &n,float &d)
{

    Vector3D vEdge0=vTr1-vTr0;vEdge0.normalize();
    Vector3D vEdge1=vTr2-vTr0;vEdge1.normalize();
    n=vEdge0.cross(vEdge1);n.normalize();
    d=-vTr0.dot(n);
}

float GetDistanceToPlane(Vector3D vPoint,Vector3D vNormal,float nDist)
{
   return vPoint.dot(vNormal)+nDist;
}
*/

float  ClosestPointOnLine(Vector3D vL0 ,Vector3D vL1,Vector3D vPoint,Vector3D &vResult)
{
	Vector3D v1=vPoint-vL0;
	Vector3D v2=vL1-vL0;

	float t=(Dot(v1,v2))/v2.lengthSq();
	if(t<0.0f)t=0.0f;
	if(t>1.0f)t=1.0f;

	vResult=vL0+v2*t;

	return Vector3D(vPoint-vResult).lengthSq();
}


float GetClosestPointOnTriEdges(Vector3D vTr0,Vector3D vTr1,Vector3D vTr2,Vector3D vPoint,Vector3D &vResult)
{
	Vector3D vRes[3];
	float	r[3];
	float   d[3];

	r[0]=ClosestPointOnLine(vTr0,vTr1,vPoint,vRes[0]);
	r[1]=ClosestPointOnLine(vTr1,vTr2,vPoint,vRes[1]);
	r[2]=ClosestPointOnLine(vTr2,vTr0,vPoint,vRes[2]);

	for(int i=0;i<3;i++)
	{
		d[i]=Vector3D(vPoint-vRes[i]).lengthSq();
	}
	if(d[0]<d[1] && d[1]<d[2])
	{
		vResult=vRes[0];
		return d[0];
	}
	else if(d[1]<d[2])
	{
		vResult=vRes[1];
		return d[1];
	}
	else
	{
		vResult=vRes[2];
		return d[2];
	}


}
/*

bool  FindLineLineCollision(Vector3D vL0,Vector3D vL1,Vector3D vLL0,Vector3D vLL1,Vector3D &vResult)
{
	//NOT TESTED
	Vector3D d1=vL1-vL0;
	Vector3D d2=vLL1-vLL0;

	float nDeno=d1.cross(d2).sqlen();
	if(nDeno==0.0f)return false;
	float t=(Vector3D(vLL0-vL0).cross(d2).dot(d1.cross(d2)))/nDeno;
	if(t>0.999f || t<0.001f)return false;
	vResult=vL0+d1*t;
	
	//Error we must check with other line's t
	return true;

}
*/

Vector3D GetClosestPointFromRay(const Vector3D& vOrg,const Vector3D& vDir,const Vector3D& p)
{
	float t=Dot(vDir,(p-vOrg));
	
	return vOrg+t*vDir;
}

float   GetDistanceFromRay(const Vector3D& vOrg,const Vector3D& vDir,const Vector3D& p)
{
	return Vector3D(p-GetClosestPointFromRay(vOrg,vDir,p)).length();
}

bool	 GetRayPlaneCollision(const Vector3D& vOrg,const Vector3D& vDir,
							  const float& d,const Vector3D& n,Vector3D& vResult,bool& bHitBack)
{
	float fDirDotN=Dot(vDir,n);
	if(fDirDotN==0.0f)return false;
	bHitBack=fDirDotN<0.0f;
	float t=(d-Dot(vOrg,n))/fDirDotN;
	
	vResult=vOrg+t*vDir;
	return true;
}

bool	GetRayXYPlaneCollision(const Vector3D& vOrg,const Vector3D& vDir,const float &d,Vector3D& vResult,bool& bHitBack)
{
	return GetRayPlaneCollision(vOrg,vDir,d,Vector3D(0.0f,0.0f,1.0f),vResult,bHitBack);
}
bool	GetRayXZPlaneCollision(const Vector3D& vOrg,const Vector3D& vDir,const float &d,Vector3D& vResult,bool& bHitBack)
{
	return GetRayPlaneCollision(vOrg,vDir,d,Vector3D(0.0f,1.0f,0.0f),vResult,bHitBack);
}
bool	GetRayYZPlaneCollision(const Vector3D& vOrg,const Vector3D& vDir,const float &d,Vector3D& vResult,bool& bHitBack)
{
	return GetRayPlaneCollision(vOrg,vDir,d,Vector3D(1.0f,0.0f,0.0f),vResult,bHitBack);
}