#include "Utils/CMouseState.h"
#include "Camera/Camera.h"
#include "Globals/Globals.hpp"
#include "Types/Math3D.h"
#include <windows.h>

CMouseState g_cMouse;

CMouseState::CMouseState()
{
	for(int i=0;i<2;i++)
	{
		m_cButton[i].m_bChanged=false;
		m_cButton[i].m_nState=BMS_NOTPRESSED;
		m_cLastState[i]=BMS_NOTPRESSED;	
	}

	POINT cPoint;
	GetCursorPos(&cPoint);
	m_nMX=cPoint.x;
	m_nMY=cPoint.y;
	m_nLastMX=m_nMX;
	m_nLastMY=m_nMY;
	
	m_vOrg=Vector3D(0,0,0);
	m_vDir=Vector3D(1,0,0);
	m_nLastFrame=0;

}

void	CMouseState::ButtonPressed	(int nButton)
{
	m_cButton[nButton].m_nState=BMS_PRESSED;	
	m_cButton[nButton].m_bChanged=(m_cButton[nButton].m_nState!=m_cLastState[nButton]);
	m_cLastState[nButton]=m_cButton[nButton].m_nState;
}
void	CMouseState::ButtonUnPressed (int nButton)
{
	m_cButton[nButton].m_nState=BMS_NOTPRESSED;	
	m_cButton[nButton].m_bChanged=(m_cButton[nButton].m_nState!=m_cLastState[nButton]);
	m_cLastState[nButton]=m_cButton[nButton].m_nState;
}
void	CMouseState::OnMouseMoved		(int nMX,int nMY)
{
	m_nLastMX=m_nMX;
	m_nLastMY=m_nMY;

	m_nMX=nMX;
	m_nMY=nMY;
}
bool	CMouseState::GetButton			(int nButton)
{
	return m_cButton[nButton].m_nState==BMS_PRESSED;
}
bool	CMouseState::Changed			(int nButton)
{
	return m_cButton[nButton].m_bChanged;
}
void	CMouseState::Update()
{
	for(int i=0;i<2;i++)
	{
		m_cButton[i].m_bChanged=(m_cButton[i].m_nState!=m_cLastState[i]);
		m_cLastState[i]=m_cButton[i].m_nState;
	}


	m_nLastMX=m_nMX;
	m_nLastMY=m_nMY;

}

void	CMouseState::GetMouseCoord	(int &nMX,int &nMY)
{
	nMX=m_nMX;
	nMY=m_nMY;

}
void	CMouseState::GetDeltaCoord	(int &nMX,int &nMY)
{
	nMX=m_nMX-m_nLastMX;
	nMY=-m_nMY+m_nLastMY;
}

void   CMouseState::GetProjection(Vector3D& vOrg,Vector3D& vDir)
{
	//If this next frame, recalculate vOrg and vDir
	if(m_nLastFrame!=g_nFrameCount)
	{
		m_vDir=GetOGLPos(m_nMX,m_nMY)-g_cMainCam.GetEye();
		m_vDir.normalize();
		m_vOrg=g_cMainCam.GetEye();
		m_nLastFrame=g_nFrameCount;
	}
	vOrg=m_vOrg;
	vDir=m_vDir;
}