#include "stdafx.h"
#include "Utils/CShaderAttribute.hpp"
#include "Utils/MiscMacros.hpp"
#include "Opengl/OpenGLExtensions.h"

#include "ErrorCheck.h"

CShaderAttr::CShaderAttr()
:m_nAttrType(0)
,m_nAttrLoc(0)
,m_nBindID(0)
,m_pcSingleType(NULL)
,m_pcVec2Type(NULL)
,m_pcVec3Type(NULL)
,m_nMaxCount(0)
,m_nCurCount(0)
{
}
CShaderAttr::~CShaderAttr()
{
	if(m_nBindID!= 0)glDeleteBuffersARB( 1,&m_nBindID );	
	
	SAFE_DELETE_ARRAY(m_pcSingleType);
	SAFE_DELETE_ARRAY(m_pcVec2Type);
	SAFE_DELETE_ARRAY(m_pcVec3Type);
}

//Allocates memory, sets Attribute Location
void	CShaderAttr::DataInit(unsigned int _nAttrType,unsigned int _nMaxCount,unsigned int _nAttrLoc)
{
	ASSERT(m_nAttrType==0,"Data already inited");
	ASSERT(_nMaxCount!=0,"Size is zero");
	m_nAttrType=_nAttrType;
	m_nMaxCount=_nMaxCount;
	m_nAttrLoc=_nAttrLoc;
	
	switch(m_nAttrType)
	{
	case 1:
		m_pcSingleType=new float[m_nMaxCount];
		break;
	case 2:
		m_pcVec2Type=new Vector2D[m_nMaxCount];
		break;
	case 3:
		m_pcVec3Type=new Vector3D[m_nMaxCount];
		break;
	default:
		FATALERROR("Incorrect Attribute Type");
	}
	
}

void	CShaderAttr::DataAdd (const float   & _sData)
{
	ASSERT(m_nCurCount<m_nMaxCount,"Too much data %d>=%d",m_nCurCount,m_nMaxCount);
	ASSERT(m_nAttrType==1,"Incorrect Type");
	m_pcSingleType[m_nCurCount++]=_sData;
}
void    CShaderAttr::DataAdd (const Vector2D& _sData)
{
	ASSERT(m_nCurCount<m_nMaxCount,"Too much data %d>=%d",m_nCurCount,m_nMaxCount);
	ASSERT(m_nAttrType==2,"Incorrect Type");
	m_pcVec2Type[m_nCurCount++]=_sData;
}
void	CShaderAttr::DataAdd (const Vector3D& _sData)
{
	ASSERT(m_nCurCount<m_nMaxCount,"Too much data %d>=%d",m_nCurCount,m_nMaxCount);
	ASSERT(m_nAttrType==3,"Incorrect Type");
	m_pcVec3Type[m_nCurCount++]=_sData;
}

//Binds and generate buffer
void	CShaderAttr::DataFinish()
{
	ASSERT(m_nBindID==0,"Incorrect Bind ID");
	ASSERT(m_nAttrType!=0,"Data was not inited, so you can't call DataFinish");
	
	glGenBuffersARB( 1, &m_nBindID );						
	glBindBufferARB( GL_ARRAY_BUFFER_ARB, m_nBindID );	
	switch(m_nAttrType)
	{	
	case 1:	
		glBufferDataARB( GL_ARRAY_BUFFER_ARB, m_nCurCount*sizeof(float), m_pcSingleType, GL_STATIC_DRAW_ARB );
		break;
	case 2:	
		glBufferDataARB( GL_ARRAY_BUFFER_ARB, m_nCurCount*2*sizeof(float), m_pcVec2Type, GL_STATIC_DRAW_ARB );
		break;
	case 3:	
		glBufferDataARB( GL_ARRAY_BUFFER_ARB, m_nCurCount*3*sizeof(float), m_pcVec3Type, GL_STATIC_DRAW_ARB );
		break;
	default:
		FATALERROR("Incorrect Attribute Type");
	}
}

//When drawing begin/end
void	CShaderAttr::BeginUse()
{
	glEnableVertexAttribArrayARB(m_nAttrLoc);
	glBindBufferARB(GL_ARRAY_BUFFER_ARB,m_nBindID);
	glVertexAttribPointerARB(m_nAttrLoc,m_nAttrType,GL_FLOAT,0,0,(char *) NULL);
}

void	CShaderAttr::EndUse()
{
	glDisableVertexAttribArrayARB(m_nAttrLoc);
}