#include "Utils/Font.h"
#include "Managers/CTextureManager.hpp"
#include "Opengl/OpenglExtensions.h"

#include "ErrorCheck.h"

GLuint font;
GLuint base;

//////////////////////////////////////////////////////////////////////////////
//                              F O N T                                     //
//////////////////////////////////////////////////////////////////////////////
GLvoid BuildFont(GLvoid)								// Build Our Font Display List
{
	float	cx;											// Holds Our X Character Coord
	float	cy;											// Holds Our Y Character Coord

	base=glGenLists(256);								// Creating 256 Display Lists
	glBindTexture(GL_TEXTURE_2D, font);			// Select Our Font Texture
	for (int loop2=0; loop2<256; loop2++)				// Loop Through All 256 Lists
	{
		cx=float(loop2%16)/16.0f;						// X Position Of Current Character
		cy=float(loop2/16)/16.0f;						// Y Position Of Current Character

		glNewList(base+loop2,GL_COMPILE);				// Start Building A List
			glBegin(GL_QUADS);							// Use A Quad For Each Character

				glTexCoord2f(cx,1-cy);					// Texture Coord (Top Left)
				glVertex2i(0,32);						// Vertex Coord (Top Left)
				
				glTexCoord2f(cx,1-cy-0.0625f);			// Texture Coord (Bottom Left)
				glVertex2i(0,0);						// Vertex Coord (Bottom Left)

				glTexCoord2f(cx+0.0625f,1-cy-0.0625f);	// Texture Coord (Bottom Right)
				glVertex2i(32,0);						// Vertex Coord (Bottom Right)

				glTexCoord2f(cx+0.0625f,1-cy);			// Texture Coord (Top Right)
				glVertex2i(32,32);						// Vertex Coord (Top Right)


			glEnd();									// Done Building Our Quad (Character)
			glTranslated(26,0,0);						// Move To The Right Of The Character
		glEndList();									// Done Building The Display List
	}													// Loop Until All 256 Are Built
}
GLvoid KillFont(GLvoid)									// Delete The Font From Memory
{
	glDeleteLists(base,256);							// Delete All 256 Display Lists
}
GLvoid glPrint(GLint x, GLint y, int set, char *fmt, ...)	// Where The Printing Happens
{

	char		text[256];					// Holds Our String
	va_list		ap;							// Pointer To List Of Arguments



	if (fmt == NULL)						// If There's No Text
		return;								// Do Nothing

	va_start(ap, fmt);						// Parses The String For Variables
	    vsprintf(text, fmt, ap);			// And Converts Symbols To Actual Numbers
	va_end(ap);								// Results Are Stored In Text

	if (set>1)								// Select Character Set
	{
		set=1;
	}
	
	glActiveTextureARB(GL_TEXTURE0_ARB);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, font);			// Select Our Font Texture
	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glPushMatrix();										// Store The Projection Matrix
	glLoadIdentity();									// Reset The Projection Matrix
	glOrtho(0,g_nWd,0,g_nHt,-1,1);						// Set Up An Ortho Screen
	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	glPushMatrix();										// Store The Modelview Matrix
	glLoadIdentity();									// Reset The Modelview Matrix

			
	glColor4f(0,0,0,1);
	glDisable(GL_DEPTH_TEST);	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	glTranslated(x-(strlen(text)/2)*26.0f,y,0);								// Position The Text (0,0 - Bottom Left)
	glListBase(base-32+(128*set));						// Choose The Font Set (0 or 1)
	glCallLists(GLsizei(strlen(text)),GL_BYTE,text);				// Write The Text To The Screen

	glEnable(GL_DEPTH_TEST);
	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glPopMatrix();										// Restore The Old Projection Matrix
	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	glPopMatrix();										// Restore The Old Projection Matrix
	glDisable(GL_BLEND);


}


GLvoid glPrintWithoutOrtho(GLint x, GLint y, int set, char *fmt, ...){


	char		text[256];					// Holds Our String
	va_list		ap;							// Pointer To List Of Arguments



	if (fmt == NULL)						// If There's No Text
		return;								// Do Nothing

	va_start(ap, fmt);						// Parses The String For Variables
	    vsprintf(text, fmt, ap);			// And Converts Symbols To Actual Numbers
	va_end(ap);								// Results Are Stored In Text

	if (set>1)								// Select Character Set
	{
		set=1;
	}

	//glPushMatrix();
	
	glBindTexture(GL_TEXTURE_2D, font);			// Select Our Font Texture

			
	glPushMatrix();
	glTranslated(x,y,0);								// Position The Text (0,0 - Bottom Left)
	glListBase(base-32+(128*set));						// Choose The Font Set (0 or 1)
	glCallLists(GLsizei(strlen(text)),GL_BYTE,text);				// Write The Text To The Screen
	glPopMatrix();



}



bool LoadFontTexture(char *filename)									// Load Bitmaps And Convert To Textures
{
	font=g_pcTexMan->LoadTexture2D(filename,false,true)->GetTextureId();
	return TRUE;
}

CConsole g_cConsole;

CConsole::CConsole()
{
	At(0,0);
	nSizeY=16;
	nSizeX=16;
}

void	CConsole::At(int _x,int _y)
{
	nX=_x;
	nY=g_nHt-60-_y;
}

void	CConsole::Printf(char *fmt, ...)
{
	char		text[256];					// Holds Our String
	va_list		ap;							// Pointer To List Of Arguments



	if (fmt == NULL)						// If There's No Text
		return;								// Do Nothing

	va_start(ap, fmt);						// Parses The String For Variables
	vsprintf(text, fmt, ap);				// And Converts Symbols To Actual Numbers
	va_end(ap);								// Results Are Stored In Text

	glPrint(nX,nY,0,text);

	if(text[strlen(text)-1]=='\n')
	{
		nY-=nSizeX;
		nX=0;
	}
	else
	{
		nX+=int(strlen(text))*nSizeX;
	}
}



