#include "Utils/MiscFuncs.hpp"
#include <string.h>
#include <malloc.h>
#include <stdio.h>

#include "ErrorCheck.h"

void strAllocNCopy(/*in/out*/char **buf,/*in*/const char *str) {
    int n = (int)strlen(str)+1;
    if (*buf==NULL) {
        *buf = (char*)malloc(n);
        ASSERT(*buf!=NULL,"Failed to get mem");
    } else {
        *buf = (char*)realloc(*buf,n);
		ASSERT(*buf!=NULL,"Failed to get mem");
    }
    strcpy_s(*buf,n,str);
}
void strFree(/*in/out*/char **buf)
{
	ASSERT(*buf!=NULL,"String is NULL");
	free(*buf);
	*buf=NULL;
}


const char *	Format(const Vector3D& v)
{
	static char strText[255];
	strText[0]='\0';
	sprintf(strText,"%.2f %.2f %.2f",v.x,v.y,v.z);
	return strText;
}
bool			TextToVec3(const char *strText,Vector3D& v)
{
	static char strPart[3][255];
	strPart[0][0]='\0';
	strPart[1][0]='\0';
	strPart[2][0]='\0';
	int i,nLen=strlen(strText),nIndex,nLocalIndex;
	
	nIndex=0;
	
	for(i=0;i<3;i++)
	{	
		nLocalIndex=0;
		while(nIndex<nLen && strText[nIndex]!=32)
		{
			strPart[i][nLocalIndex]= strText[nIndex];
			nLocalIndex++;
			nIndex++;
		}
		while(nIndex<nLen && strText[nIndex]==32);
		strPart[i][nLocalIndex]='\0';
	}
	
	return true;
}