/***********      .---.         .-"-.      *******************\
* -------- *     /   ._.       /  ` \     * ---------------- *
* Author's *     \_  (__\      \_v_/     * humus@rogers.com *
*   note   *     //   \\       //   \\     * ICQ #47010716    *
* -------- *    ((     ))     ((     ))    * ---------------- *
*          ****--""---""-------""---""--****                  ********\
* This file is a part of the work done by Humus. You are free to use  *
* the code in any way you like, modified, unmodified or copy'n'pasted *
* into your own work. However, I expect you to respect these points:  *
*  @ If you use this file and its contents unmodified, or use a major *
*    part of this file, please credit the author and leave this note. *
*  @ For use in anything commercial, please request my approval.      *
*  @ Share your work and ideas too as much as you can.                *
\*********************************************************************/

#include "Platform/Platform.h"

// Utility functions
#ifdef _WIN32

void ErrorMsg(const char *string){
	MessageBox(NULL, string, "Error", MB_OK | MB_ICONERROR);
}

void WarningMsg(const char *string){
	MessageBox(NULL, string, "Warning", MB_OK | MB_ICONWARNING);
}

void InfoMsg(const char *string){
	MessageBox(NULL, string, "Information", MB_OK | MB_ICONINFORMATION);
}

#else

#include <gtk/gtk.h>

// This is such a hack, but at least it works.
gboolean idle(gpointer data){
	gtk_main_quit();
	return FALSE;
}

void MessageBox(const char *string, const GtkMessageType msgType){
	GtkWidget *dialog = gtk_message_dialog_new(NULL, GTK_DIALOG_DESTROY_WITH_PARENT, msgType, GTK_BUTTONS_OK, string);
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);
	g_idle_add(idle, NULL);
	gtk_main();
}

void ErrorMsg(const char *string){
	MessageBox(string, GTK_MESSAGE_ERROR);
}

void WarningMsg(const char *string){
	MessageBox(string, GTK_MESSAGE_WARNING);
}

void InfoMsg(const char *string){
	MessageBox(string, GTK_MESSAGE_INFO);
}

#endif



#ifdef DEBUG

#include <stdio.h>

#ifdef _WIN32

void failedAssert(char *file, int line, char *statement){
	static bool debug = true;

	if (debug){
		char str[1024];

		sprintf(str, "Failed: (%s)\n\nFile: %s\nLine: %d\n\n", statement, file, line);

		if (IsDebuggerPresent()){
			strcat(str, "Debug?");
			int res = MessageBox(NULL, str, "Assert failed", MB_YESNOCANCEL | MB_ICONERROR);
			if (res == IDYES){
				_asm int 0x03;
			} else if (res == IDCANCEL){
				debug = false;
			}
		} else {
			strcat(str, "Display more asserts?");
			if (MessageBox(NULL, str, "Assert failed", MB_YESNO | MB_ICONERROR | MB_DEFBUTTON2) != IDYES){
				debug = false;
			}
		}
	}
}

void outputDebugString(const char *str){
	OutputDebugString(str);
	OutputDebugString("\n");
}

#else

void outputDebugString(const char *str){
	printf("%s\n", str);
}

#endif // _WIN32
#endif // DEBUG
