#include "Shaders/CShaderProgram.hpp"
#include "Globals/Globals.hpp"
#include <fstream>


using namespace std;


#include "ErrorCheck.h"




CShaderProgram::CShaderProgram()
{
	compiler_log = 0;
	is_compiled = false;
	program_type = 0;
	ProgramObject = 0;
	ShaderSource = 0;
	_memalloc = false;

}

//----------------------------------------------------------------------------- 

CShaderProgram::~CShaderProgram()
{
	if (compiler_log!=0) free(compiler_log);
	if (ShaderSource!=0)   
	{
		if (_memalloc)
			delete[] ShaderSource;  // free ASCII Source
	}

	if (is_compiled)
	{ 
		glDeleteObjectARB(ProgramObject);
		CHECK_GL_ERROR();
	}
}

//----------------------------------------------------------------------------- 
unsigned long getFileLength(ifstream& file)
{
	if(!file.good()) return 0;

	unsigned long pos=file.tellg();
	file.seekg(0,ios::end);
	unsigned long len = file.tellg();
	file.seekg(ios::beg);

	return len;
}


//----------------------------------------------------------------------------- 

int CShaderProgram::load(char* filename)
{

	FILE *file = fopen(filename,"rb");

	if(!file)return -1;

	fseek (file, 0, SEEK_END);
	unsigned long len = ftell (file);
	fseek (file, 0, SEEK_SET);

	if (len==0) return -2;   // "Empty File" 


	if (ShaderSource!=0)    // there is already a source loaded, free it!
	{
		if (_memalloc)
			delete[] ShaderSource;
	}


	ShaderSource = (GLubyte*) (new char[len+1]);
	if (ShaderSource == 0) return -3;   // can't reserve memory
	_memalloc = true;


	fread(ShaderSource,1,len,file);
	ShaderSource[len] = 0;
	fclose(file);




	return 0;


	/*
	ifstream file;
	file.open(filename, ios::in);
	if(!file) return -1;

	unsigned long len = getFileLength(file);

	if (len==0) return -2;   // "Empty File" 

	if (ShaderSource!=0)    // there is already a source loaded, free it!
	{
		if (_memalloc)
			delete[] ShaderSource;
	}

	ShaderSource = (GLubyte*) (new char[len+1]);
	if (ShaderSource == 0) return -3;   // can't reserve memory
	_memalloc = true;


	ShaderSource[len] = 0;  // len isn't always strlen cause some characters are stripped in ascii read...
	// it is important to 0-terminate the real length later, len is just max possible value...

	unsigned int i=0;
	while (file.good())
	{
		ShaderSource[i++] = file.get();       // get character from file
		if (i>len) i=len;   // coding guidelines...
	}

	ShaderSource[i] = 0;  // 0 terminate it.

	file.close();
	//*/

	return 0;
}

//----------------------------------------------------------------------------- 

void CShaderProgram::LoadFromMemory(const char* program)
{
	if (ShaderSource!=0)    // there is already a source loaded, free it!
	{
		if (_memalloc)
			delete[] ShaderSource;
	}
	_memalloc = false;
	ShaderSource = (GLubyte*) program;

}


// ----------------------------------------------------
// Compiler Log: Ausgabe der Compiler Meldungen in String

char* CShaderProgram::getCompilerLog(void)
{    
	if (!g_bGLSL_Supported) return aGLSLErrorString[0];

	int blen = 0;	
	int slen = 0;	


	if (ProgramObject==0) return aGLSLErrorString[1];

	glGetObjectParameterivARB(ProgramObject, GL_OBJECT_INFO_LOG_LENGTH_ARB , &blen);
	CHECK_GL_ERROR();

	if (blen > 1)
	{
		if (compiler_log!=0) 
		{   
			free(compiler_log);
			compiler_log =0;
		}
		if ((compiler_log = (GLcharARB*)malloc(blen)) == NULL) 
		{
			printf("ERROR: Could not allocate compiler_log buffer\n");
			return aGLSLErrorString[3];
		}

		glGetInfoLogARB(ProgramObject, blen, &slen, compiler_log);
		CHECK_GL_ERROR();
		//FATALERROR("compiler_log: %s \n", compiler_log);     
	}
	if (compiler_log!=0)
		return (char*) compiler_log;    

	return aGLSLErrorString[4];
}

// ----------------------------------------------------

bool CShaderProgram::compile(void)
{
	if (!g_bGLSL_Supported) return false;

	is_compiled = false;

	int compiled = 0;

	if (ShaderSource==0) return false;

	GLint	length = (GLint) strlen((const char*)ShaderSource);
	glShaderSourceARB(ProgramObject, 1, (const GLcharARB **)&ShaderSource, &length);
	CHECK_GL_ERROR();

	glCompileShaderARB(ProgramObject); 
	CHECK_GL_ERROR();
	glGetObjectParameterivARB(ProgramObject, GL_OBJECT_COMPILE_STATUS_ARB, &compiled);
	CHECK_GL_ERROR();

	if (compiled) is_compiled=true;

	return is_compiled;
}