#include "Shaders/ShaderMem/ShaderStorage.hpp"


char grassVS[]={
	"\nuniform float time;   \
\nvarying vec2 texCoord;   \
\n   \
\nattribute vec2 info;   \
\n   \
\nvarying float fLightModifier;   \
\n   \
\n   \
\n   \
\nvoid main(void)   \
\n{   \
\n texCoord = gl_MultiTexCoord0.xy;   \
\n vec4 displacedVertex;   \
\n displacedVertex = gl_Vertex;   \
\n    \
\n float power=(gl_Vertex.y-info.y-5.0)/2.0;   \
\n float ssin=sin(time+info.x);   \
\n if(gl_Vertex.y-info.y>=5.0)   \
\n {   \
\n  displacedVertex.y+=-ssin*ssin*power;   \
\n  displacedVertex.x+=ssin*(power/8.0)+power;   \
\n }   \
\n   \
\n gl_Position = gl_ModelViewProjectionMatrix * displacedVertex;      \
\n    \
\n   \
\n    \
\n    \
\n if(gl_Position.z<4000.0)   \
\n  fLightModifier=1.0;   \
\n else   \
\n  fLightModifier=4000.0/(gl_Position.z*gl_Position.z);   \
\n    \
\n}	"};
char grassFS[]={
	"\nuniform sampler2D colorMap;   \
\nvarying vec2 texCoord;   \
\n   \
\nvarying float fLightModifier;   \
\n   \
\n   \
\n   \
\nvoid main (void)   \
\n{   \
\n   \
\n   \
\n   \
\n vec4 color=texture2D(colorMap, texCoord);   \
\n color  *=fLightModifier;   \
\n if(color.g>0.5)   \
\n  color.a=1.0;   \
\n else if(color.g<0.3)   \
\n  discard;   \
\n else color.a=color.g+0.5;   \
\n gl_FragColor = color ;   \
\n   \
\n}	"};
char paralax_bumpmapVS[]={
	"\nvarying vec3 lightVec;    \
\nvarying vec3 viewVec;   \
\nvarying vec2 texCoord;   \
\nattribute vec3 vTangent;    \
\n                        \
\n   \
\nvoid main(void)   \
\n{   \
\n gl_Position = ftransform();   \
\n texCoord = gl_MultiTexCoord0.xy*vec2(1.0, 1.0);   \
\n    \
\n vec3 n = normalize(gl_NormalMatrix * gl_Normal);   \
\n vec3 t = normalize(gl_NormalMatrix * vTangent);   \
\n vec3 b = cross(n, t);   \
\n    \
\n vec3 v;   \
\n vec3 vVertex = vec3(gl_ModelViewMatrix * gl_Vertex);   \
\n vec3 lVec = gl_LightSource[0].position.xyz - vVertex;   \
\n   \
\n v.x = dot(lVec, t);   \
\n v.y = dot(lVec, b);   \
\n v.z = dot(lVec, n);   \
\n lightVec = v;   \
\n   \
\n vec3 vVec = -vVertex;   \
\n v.x = dot(vVec, t);   \
\n v.y = dot(vVec, b);   \
\n v.z = dot(vVec, n);   \
\n viewVec = v;   \
\n}	"};
char paralax_bumpmapFS[]={
	"\nvarying vec3 lightVec;   \
\nvarying vec3 viewVec;   \
\nvarying vec2 texCoord;   \
\nuniform sampler2D colorMap;   \
\nuniform sampler2D normalMap;   \
\nuniform sampler2D heightMap;   \
\nuniform float invRadius;   \
\n   \
\nvoid main (void)   \
\n{   \
\n vec3 lVec = normalize(lightVec);   \
\n vec3 vVec = normalize(viewVec);   \
\n    \
\n // Calculate offset, scale & biais   \
\n float height = texture2D(heightMap, texCoord).x ;   \
\n //vec2 newTexCoord = texCoord + ((height * 0.03 - 0.015) * (-vVec.xy));   \
\n vec2 newTexCoord = texCoord + ((height * 0.04 - 0.02) * (-vVec.xy));   \
\n    \
\n    \
\n vec4 base = texture2D(colorMap, newTexCoord);   \
\n vec3 bump = normalize(texture2D(normalMap, newTexCoord).xyz * 2.0 - 1.0);   \
\n bump = normalize(bump);   \
\n   \
\n float diffuse = max( dot(lVec, bump), 0.0 );   \
\n    \
\n float specular = pow(clamp(dot(reflect(-vVec, bump), lVec), 0.0, 1.0), gl_FrontMaterial.shininess );   \
\n   \
\n vec4 vAmbient = gl_LightSource[0].ambient * gl_FrontMaterial.ambient;   \
\n vec4 vDiffuse = gl_LightSource[0].diffuse * gl_FrontMaterial.diffuse * diffuse;    \
\n vec4 vSpecular = gl_LightSource[0].specular * gl_FrontMaterial.specular *specular;    \
\n gl_FragColor = vAmbient*base + (vDiffuse*base + vSpecular);    \
\n}	"};
char terrainVS[]={
	"\nvec4 Ambient;   \
\nvec4 Diffuse;   \
\nvec4 Specular;   \
\nvarying vec4 vColorData;   \
\n   \
\nvoid pointLight(in int i, in vec3 normal, in vec3 eye, in vec3 ecPosition3)   \
\n{   \
\n    float nDotVP;         // normal . light direction   \
\n    float nDotHV;         // normal . light half vector   \
\n    float pf;                   // power factor   \
\n    float attenuation;    // computed attenuation factor   \
\n    float d;                    // distance from surface to light source   \
\n    vec3  VP;               // direction from surface to light position   \
\n    vec3  halfVector;    // direction of maximum highlights   \
\n   \
\n    // Compute vector from surface to light position   \
\n    VP = vec3 (gl_LightSource[0].position) - ecPosition3;   \
\n   \
\n    // Compute distance between surface and light position   \
\n    d = length(VP);   \
\n   \
\n    // Normalize the vector from surface to light position   \
\n    VP = normalize(VP);   \
\n   \
\n    // Compute attenuation   \
\n    attenuation = 1.0 / (gl_LightSource[0].constantAttenuation +   \
\n                    gl_LightSource[0].linearAttenuation * d +   \
\n                    gl_LightSource[0].quadraticAttenuation * d * d);   \
\n    halfVector = normalize(VP + eye);   \
\n    nDotVP = max(0.0, dot(normal, VP));   \
\n    nDotHV = max(0.0, dot(normal, halfVector));   \
\n   \
\n    if (nDotVP == 0.0)   \
\n        pf = 0.0;   \
\n    else   \
\n        pf = pow(nDotHV, gl_FrontMaterial.shininess);   \
\n   \
\n    Ambient  += gl_LightSource[0].ambient * attenuation;   \
\n    Diffuse  += gl_LightSource[0].diffuse * nDotVP * attenuation;   \
\n    Specular += gl_LightSource[0].specular * pf * attenuation;   \
\n}   \
\n   \
\nvec3 fnormal(void)   \
\n{   \
\n    //Compute the normal    \
\n    vec3 normal = gl_NormalMatrix * gl_Normal;   \
\n    return normal;   \
\n}   \
\n   \
\nvoid flight(in vec3 normal, in vec4 ecPosition, float alphaFade)   \
\n{   \
\n    vec4 color;   \
\n    vec3 ecPosition3;   \
\n    vec3 eye;   \
\n   \
\n    ecPosition3 = (vec3 (ecPosition)) / ecPosition.w;   \
\n    eye = vec3 (0.0, 0.0, 1.0);   \
\n   \
\n    // Clear the light intensity accumulators   \
\n    Ambient  = vec4 (0.0);   \
\n    Diffuse  = vec4 (0.0);   \
\n    Specular = vec4 (0.0);   \
\n   \
\n    pointLight(0, normal, eye, ecPosition3);   \
\n   \
\n    color = gl_FrontLightModelProduct.sceneColor +   \
\n                Ambient  * gl_FrontMaterial.ambient +   \
\n                Diffuse  * gl_FrontMaterial.diffuse;   \
\n    color += Specular * gl_FrontMaterial.specular;   \
\n    color = clamp( color, 0.0, 1.0 );   \
\n    gl_FrontColor = color;   \
\n    gl_FrontColor.a *= alphaFade;   \
\n}     \
\n   \
\nvoid main(void)   \
\n{   \
\n   \
\n   \
\n gl_TexCoord[0] = gl_MultiTexCoord0;   \
\n gl_TexCoord[1] = gl_MultiTexCoord1;   \
\n    \
\n   \
\n vec3  transformedNormal;   \
\n float alphaFade = 1.0;   \
\n   \
\n // Eye-coordinate position of vertex, needed in various calculations   \
\n vec4 ecPosition = gl_ModelViewMatrix * gl_Vertex;   \
\n   \
\n // Do fixed functionality vertex transform   \
\n gl_Position = ftransform();   \
\n transformedNormal = fnormal();   \
\n flight(transformedNormal, ecPosition, alphaFade);   \
\n   \
\n vColorData=gl_Color;   \
\n   \
\n}   \
\n	"};
char terrainFS[]={
	"\nuniform sampler2D myTexture1;   \
\nuniform sampler2D myTexture2;   \
\nuniform sampler2D myTexture3;   \
\nuniform sampler2D myTexture4;   \
\n   \
\nvarying vec4 vColorData;   \
\n   \
\nvoid main (void)   \
\n{   \
\n   \
\n vec4 sTexValue=texture2D(myTexture1, gl_TexCoord[0].xy)*vColorData.x   \
\n     +texture2D(myTexture2, gl_TexCoord[0].xy)*vColorData.y   \
\n     +texture2D(myTexture3, gl_TexCoord[0].xy)*vColorData.z   \
\n     +texture2D(myTexture4, gl_TexCoord[0].xy)*vColorData.w;   \
\n   \
\n gl_FragColor = sTexValue*gl_Color;   \
\n   \
\n   \
\n}	"};