/***********      .---.         .-"-.      *******************\
* -------- *     /   ._.       /  ` \     * ---------------- *
* Author's *     \_  (__\      \_v_/     * humus@rogers.com *
*   note   *     //   \\       //   \\     * ICQ #47010716    *
* -------- *    ((     ))     ((     ))    * ---------------- *
*          ****--""---""-------""---""--****                  ********\
* This file is a part of the work done by Humus. You are free to use  *
* the code in any way you like, modified, unmodified or copy'n'pasted *
* into your own work. However, I expect you to respect these points:  *
*  @ If you use this file and its contents unmodified, or use a major *
*    part of this file, please credit the author and leave this note. *
*  @ For use in anything commercial, please request my approval.      *
*  @ Share your work and ideas too as much as you can.                *
\*********************************************************************/


#include "Sounds/Audio.h"

#include "ErrorCheck.h"

Audio *g_pcSoundMan;


Audio::Audio(){
	dev = alcOpenDevice(NULL);
	ctx = alcCreateContext(dev, NULL);
	alcMakeContextCurrent(ctx);

//	alDistanceModel(AL_INVERSE_DISTANCE);
	alDistanceModel(AL_INVERSE_DISTANCE_CLAMPED);
	//alListenerf(AL_GAIN, 0.0f);
}

Audio::~Audio(){
	clear();

	alcMakeContextCurrent(NULL);
	alcDestroyContext(ctx);
	alcCloseDevice(dev);
}

void Audio::clear(){
	int index = sounds.getCount();
	while (index--){
		deleteSound(index);
	}

	index = soundSources.getCount();
	while (index--){
		deleteSoundSource(index);
	}
}

SoundID Audio::addSound(const char *fileName, unsigned int flags){
	Sound sound;

	// Clear error flag
	alGetError();

	const char *ext = strrchr(fileName, '.') + 1;
	char str[256];

	ALboolean al_bool;
	alutLoadWAVFile(fileName, &sound.format, (void **) &sound.samples, &sound.size, &sound.sampleRate, &al_bool);


	alGenBuffers(1, &sound.buffer);
	alBufferData(sound.buffer, sound.format, sound.samples, sound.size, sound.sampleRate);
	if (alGetError() != AL_NO_ERROR)
	{
		alDeleteBuffers(1, &sound.buffer);

		FATALERROR( "Couldn't open \"%s\"", fileName);
		ErrorMsg(str);
		return SOUND_NONE;
	}

	return insertSound(sound);
}

SoundID Audio::insertSound(Sound &sound){
	for (uint i = 0; i < sounds.getCount(); i++){
		if (sounds[i].samples == NULL){
			sounds[i] = sound;
			return i;
		}
	}

	return sounds.add(sound);
}

void Audio::deleteSound(const SoundID sound){
	if (sounds[sound].samples){
		alDeleteBuffers(1, &sounds[sound].buffer);

		alutUnloadWAV(sounds[sound].format, sounds[sound].samples, sounds[sound].size, sounds[sound].sampleRate);
		//delete sound.samples;
		sounds[sound].samples = NULL;
	}
}

SoundSourceID Audio::addSoundSource(const SoundID sound, uint flags){
	SoundSource soundSource;

	soundSource.sound = sound;

	alGenSources(1, &soundSource.source);
	alSourcei(soundSource.source, AL_LOOPING, (flags & LOOPING)? AL_TRUE : AL_FALSE);
	alSourcei(soundSource.source, AL_SOURCE_RELATIVE, (flags & RELATIVEPOS)? AL_TRUE : AL_FALSE);
	alSourcei(soundSource.source, AL_BUFFER, sounds[sound].buffer);
	alSourcef(soundSource.source, AL_MIN_GAIN, 0.0f);
	alSourcef(soundSource.source, AL_MAX_GAIN, 1.0f);

	return insertSoundSource(soundSource);
}

SoundID Audio::insertSoundSource(SoundSource &source){
	for (uint i = 0; i < soundSources.getCount(); i++){
		if (soundSources[i].sound == SOUND_NONE){
			soundSources[i] = source;
			return i;
		}
	}

	return soundSources.add(source);
}

void Audio::deleteSoundSource(const SoundSourceID source){
	if (soundSources[source].sound != SOUND_NONE){
		alDeleteSources(1, &soundSources[source].source);
		soundSources[source].sound = SOUND_NONE;
	}
}

void Audio::play(const SoundSourceID source){
	alSourcePlay(soundSources[source].source);
}

void Audio::stop(const SoundSourceID source){
	alSourceStop(soundSources[source].source);
}

void Audio::pause(const SoundSourceID source){
	alSourcePause(soundSources[source].source);
}

bool Audio::isPlaying(const SoundSourceID source){
	ALint state;
	alGetSourcei(soundSources[source].source, AL_SOURCE_STATE, &state);

	return (state == AL_PLAYING);
}

void Audio::setListenerOrientation(const Vector3D &position, const Vector3D &zDir){
	alListenerfv(AL_POSITION, position);

	float orient[] = { zDir.x, zDir.y, zDir.z, 0, -1, 0 };
	alListenerfv(AL_ORIENTATION, orient);
}

void Audio::setSourceGain(const SoundSourceID source, const float gain){
	alSourcef(soundSources[source].source, AL_GAIN, gain);
}

void Audio::setSourcePosition(const SoundSourceID source, const Vector3D &position){
	alSourcefv(soundSources[source].source, AL_POSITION, position);
}

void Audio::setSourceAttenuation(const SoundSourceID source, const float rollOff, const float refDistance){
	alSourcef(soundSources[source].source, AL_REFERENCE_DISTANCE, refDistance);
	alSourcef(soundSources[source].source, AL_ROLLOFF_FACTOR, rollOff);
}
