//
// Some simple math routines
//
// Author: Alex V. Boreskoff
//
// Last modified: 13/11/2002
//

#include    "Types/Math3D.h"
#include	"stdafx.h"


Vector3D    closestPointToSegment ( const Vector3D& p, const Vector3D& a, const Vector3D& b )
{
    Vector3D c = p - a;
    Vector3D v = b - a;
    float    d = v.length ();

    v /= d;                 // normalize v

    float   t = v & c;

    if ( t < 0.0f )
        return a;
    else
    if ( t > d )
        return b;

    return a + t*v;
}

int	computeNearPointMask ( const Vector3D& n )
{
    if ( n.x > 0.0f )
        if ( n.y > 0.0f )
            if ( n.z > 0.0f )
                return 0;
            else
                return 4;
        else
            if ( n.z > 0.0f )
                return 2;
            else
                return 6;
    else
        if ( n.y > 0.0f )
            if ( n.z > 0.0f )
                return 1;
            else
                return 5;
        else
            if ( n.z > 0.0f )
                return 3;
            else
                return 7;
}
/*
pitch = asin ( r21 );

if ( pitch < M_PI / 2 )
{
	if ( pitch > -M_PI / 2 )
	{
		roll = -atan2 ( -r01, r11 );
		yaw  =  atan2 ( -r20, r22 );
	}
	else
	{
		roll = atan2 ( ro2, r00 );
		yaw  = 0;
	}
}
else
{
	roll = atan2 ( ro2, r00 );
	yaw  = 0;
}

*/
Vector3D GetOGLPos(int x, int y)
{
	GLint viewport[4];
	GLdouble modelview[16];
	GLdouble projection[16];
	GLint winX, winY;
	GLfloat winZ;
	GLdouble posX, posY, posZ;

	glGetDoublev( GL_MODELVIEW_MATRIX, modelview );
	glGetDoublev( GL_PROJECTION_MATRIX, projection );
	glGetIntegerv( GL_VIEWPORT, viewport );

	winX = x;
	winY = viewport[3] - y;

	glReadPixels( winX,winY, 1,1, GL_DEPTH_COMPONENT, GL_FLOAT, &winZ );



	gluUnProject( winX, winY, winZ, modelview, projection, viewport, &posX, &posY, &posZ);

	return Vector3D((float)posX, (float)posY, (float)posZ);
}


