#include <math.h>
#include <stdio.h>
#include "Types/Matrix4D.h"

#include "ErrorCheck.h"

Matrix4D :: Matrix4D ( float a )
{
	x [0][1] = x[0][2] = x[0][3] =
	x [1][0] = x[1][2] = x[1][3] =
	x [2][0] = x[2][1] = x[2][3] =
	x [3][0] = x[3][1] = x[3][2] = 0.0f;
	
	x [0][0] = x [1][1] = x [2][2] = x [3][3] =  a;

}

Matrix4D :: Matrix4D ( const Matrix4D& a )
{
	x [0][0] = a.x [0][0];
	x [0][1] = a.x [0][1];
	x [0][2] = a.x [0][2];
	x [0][3] = a.x [0][3];
	
	x [1][0] = a.x [1][0];
	x [1][1] = a.x [1][1];
	x [1][2] = a.x [1][2];
	x [1][3] = a.x [1][3];
	
	x [2][0] = a.x [2][0];
	x [2][1] = a.x [2][1];
	x [2][2] = a.x [2][2];
	x [2][3] = a.x [2][3];
	
	x [3][0] = a.x [3][0];
	x [3][1] = a.x [3][1];
	x [3][2] = a.x [3][2];
	x [3][3] = a.x [3][3];


}

Matrix4D& Matrix4D :: operator = ( const Matrix4D& a )
{
	x [0][0] = a.x [0][0];
	x [0][1] = a.x [0][1];
	x [0][2] = a.x [0][2];
	x [0][3] = a.x [0][3];
	
	x [1][0] = a.x [1][0];
	x [1][1] = a.x [1][1];
	x [1][2] = a.x [1][2];
	x [1][3] = a.x [1][3];
	
	x [2][0] = a.x [2][0];
	x [2][1] = a.x [2][1];
	x [2][2] = a.x [2][2];
	x [2][3] = a.x [2][3];
	
	x [3][0] = a.x [3][0];
	x [3][1] = a.x [3][1];
	x [3][2] = a.x [3][2];
	x [3][3] = a.x [3][3];


	return *this;
}

Matrix4D& Matrix4D :: operator = ( float a )
{
	x [0][1] = x[0][2] = x[0][3] =
	x [1][0] = x[1][2] = x[1][3] =
	x [2][0] = x[2][1] = x[2][3] =
	x [3][0] = x[3][1] = x[3][2] = 0.0f;
	
	x [0][0] = x [1][1] = x [2][2] = x [3][3] = a;

	return *this;
}

Matrix4D& Matrix4D :: operator += ( const Matrix4D& a )
{
	x [0][0] += a.x [0][0];
	x [0][1] += a.x [0][1];
	x [0][2] += a.x [0][2];
	x [0][3] += a.x [0][3];
	
	x [1][0] += a.x [1][0];
	x [1][1] += a.x [1][1];
	x [1][2] += a.x [1][2];
	x [1][3] += a.x [1][3];
	
	x [2][0] += a.x [2][0];
	x [2][1] += a.x [2][1];
	x [2][2] += a.x [2][2];
	x [2][3] += a.x [2][3];
	
	x [3][0] += a.x [3][0];
	x [3][1] += a.x [3][1];
	x [3][2] += a.x [3][2];
	x [3][3] += a.x [3][3];

	return *this;
}

Matrix4D& Matrix4D :: operator -= ( const Matrix4D& a )
{
	x [0][0] -= a.x [0][0];
	x [0][1] -= a.x [0][1];
	x [0][2] -= a.x [0][2];
	x [0][3] -= a.x [0][3];
	
	x [1][0] -= a.x [1][0];
	x [1][1] -= a.x [1][1];
	x [1][2] -= a.x [1][2];
	x [1][3] -= a.x [1][3];
	
	x [2][0] -= a.x [2][0];
	x [2][1] -= a.x [2][1];
	x [2][2] -= a.x [2][2];
	x [2][3] -= a.x [2][3];
	
	x [3][0] -= a.x [3][0];
	x [3][1] -= a.x [3][1];
	x [3][2] -= a.x [3][2];
	x [3][3] -= a.x [3][3];

	return *this;
}

Matrix4D& Matrix4D :: operator *= ( const Matrix4D& a )
{
	Matrix4D c ( *this );

	x[0][0]=c.x[0][0]*a.x[0][0]+c.x[0][1]*a.x[1][0]+c.x[0][2]*a.x[2][0]+c.x[0][3]*a.x[3][0];
	x[0][1]=c.x[0][0]*a.x[0][1]+c.x[0][1]*a.x[1][1]+c.x[0][2]*a.x[2][1]+c.x[0][3]*a.x[3][1];
	x[0][2]=c.x[0][0]*a.x[0][2]+c.x[0][1]*a.x[1][2]+c.x[0][2]*a.x[2][2]+c.x[0][3]*a.x[3][2];
	x[0][3]=c.x[0][0]*a.x[0][3]+c.x[0][1]*a.x[1][3]+c.x[0][2]*a.x[2][3]+c.x[0][3]*a.x[3][3];
	
	x[1][0]=c.x[1][0]*a.x[0][0]+c.x[1][1]*a.x[1][0]+c.x[1][2]*a.x[2][0]+c.x[1][3]*a.x[3][0];
	x[1][1]=c.x[1][0]*a.x[0][1]+c.x[1][1]*a.x[1][1]+c.x[1][2]*a.x[2][1]+c.x[1][3]*a.x[3][1];
	x[1][2]=c.x[1][0]*a.x[0][2]+c.x[1][1]*a.x[1][2]+c.x[1][2]*a.x[2][2]+c.x[1][3]*a.x[3][2];
	x[1][3]=c.x[1][0]*a.x[0][3]+c.x[1][1]*a.x[1][3]+c.x[1][2]*a.x[2][3]+c.x[1][3]*a.x[3][3];
	
	x[2][0]=c.x[2][0]*a.x[0][0]+c.x[2][1]*a.x[1][0]+c.x[2][2]*a.x[2][0]+c.x[2][3]*a.x[3][0];
	x[2][1]=c.x[2][0]*a.x[0][1]+c.x[2][1]*a.x[1][1]+c.x[2][2]*a.x[2][1]+c.x[2][3]*a.x[3][1];
	x[2][2]=c.x[2][0]*a.x[0][2]+c.x[2][1]*a.x[1][2]+c.x[2][2]*a.x[2][2]+c.x[2][3]*a.x[3][2];
	x[2][3]=c.x[2][0]*a.x[0][3]+c.x[2][1]*a.x[1][3]+c.x[2][2]*a.x[2][3]+c.x[2][3]*a.x[3][3];
	
	x[3][0]=c.x[3][0]*a.x[0][0]+c.x[3][1]*a.x[1][0]+c.x[3][2]*a.x[2][0]+c.x[3][3]*a.x[3][0];
	x[3][1]=c.x[3][0]*a.x[0][1]+c.x[3][1]*a.x[1][1]+c.x[3][2]*a.x[2][1]+c.x[3][3]*a.x[3][1];
	x[3][2]=c.x[3][0]*a.x[0][2]+c.x[3][1]*a.x[1][2]+c.x[3][2]*a.x[2][2]+c.x[3][3]*a.x[3][2];
	x[3][3]=c.x[3][0]*a.x[0][3]+c.x[3][1]*a.x[1][3]+c.x[3][2]*a.x[2][3]+c.x[3][3]*a.x[3][3];

	return *this;
}

Matrix4D& Matrix4D :: operator *= ( float a )
{
	x [0][0] *= a;
	x [0][1] *= a;
	x [0][2] *= a;
	x [0][3] *= a;
	
	x [1][0] *= a;
	x [1][1] *= a;
	x [1][2] *= a;
	x [1][3] *= a;
	
	x [2][0] *= a;
	x [2][1] *= a;
	x [2][2] *= a;
	x [2][3] *= a;
	
	x [3][0] *= a;
	x [3][1] *= a;
	x [3][2] *= a;
	x [3][3] *= a;

	return *this;
}

Matrix4D& Matrix4D :: operator /= ( float a )
{
	x [0][0] /= a;
	x [0][1] /= a;
	x [0][2] /= a;
	x [0][3] /= a;
	
	x [1][0] /= a;
	x [1][1] /= a;
	x [1][2] /= a;
	x [1][3] /= a;
	
	x [2][0] /= a;
	x [2][1] /= a;
	x [2][2] /= a;
	x [2][3] /= a;
	
	x [3][0] /= a;
	x [3][1] /= a;
	x [3][2] /= a;
	x [3][3] /= a;

	return *this;
};

float	Matrix4D :: det () const
{
	//Check this (too much math)
	return x[0][0]*(x[1][1]*(x[2][2]*x[3][3]-x[2][3]*x[3][2]) + x[1][2]*(x[2][3]*x[3][1]-x[2][1]*x[3][3])+x[1][3]*(x[2][1]*x[3][2]-x[2][2]*x[3][1]))
	      -x[0][1]*(x[1][0]*(x[2][2]*x[3][3]-x[2][3]*x[3][2]) + x[1][2]*(x[2][3]*x[3][0]-x[2][0]*x[3][3])+x[1][3]*(x[2][0]*x[3][2]-x[2][2]*x[3][0]))
	      +x[0][3]*(x[1][0]*(x[2][1]*x[3][3]-x[2][3]*x[3][1]) + x[1][1]*(x[2][3]*x[3][0]-x[2][0]*x[3][3])+x[1][3]*(x[2][0]*x[3][1]-x[2][1]*x[3][0]))
	      -x[0][4]*(x[1][0]*(x[2][1]*x[3][2]-x[2][2]*x[3][1]) + x[1][1]*(x[2][2]*x[3][0]-x[2][0]*x[3][2])+x[1][2]*(x[2][0]*x[3][1]-x[2][1]*x[3][0]));
}
//Picks values from m and transfers them to x[][]
void		Matrix4D :: setMatrix(const float m[16])
{
	x [0][0] = m[0];
	x [1][0] = m[1];
	x [2][0] = m[2];
	x [3][0] = m[3];

	x [0][1] = m[4];
	x [1][1] = m[5];
	x [2][1] = m[6];
	x [3][1] = m[7];

	x [0][2] = m[8];
	x [1][2] = m[9];
	x [2][2] = m[10];
	x [3][2] = m[11];
	
	x [0][3] = m[12];
	x [1][3] = m[13];
	x [2][3] = m[14];
	x [3][3] = m[15];
}
//Picks values from x[][] and transfers them to m
void		Matrix4D :: getMatrix( float m[16])
{
	m [0]  = x [0][0];
	m [1]  = x [1][0];
	m [2]  = x [2][0];
	m [3]  = x [3][0];

	m [4]  = x [0][1];
	m [5]  = x [1][1];
	m [6]  = x [2][1];
	m [7]  = x [3][1];

	m [8]  = x [0][2];
	m [9]  = x [1][2];
	m [10] = x [2][2];
	m [11] = x [3][2];
	
	m [12] = x [0][3];
	m [13] = x [1][3];
	m [14] = x [2][3];
	m [15] = x [3][3];
}
Matrix4D&	Matrix4D :: invert ()
{
	FATALERROR("Not implemented");
	float	 det;
	Matrix4D a;
					// compute a determinant
	det = x [0][0]*(x [1][1]*x [2][2]-x [1][2]*x [2][1]) -
	      x [0][1]*(x [1][0]*x [2][2]-x [1][2]*x [2][0]) +
	      x [0][2]*(x [1][0]*x [2][1]-x [1][1]*x [2][0]);

	a.x [0][0] = (x [1][1]*x [2][2]-x [1][2]*x [2][1]) / det;
	a.x [0][1] = (x [0][2]*x [2][1]-x [0][1]*x [2][2]) / det;
	a.x [0][2] = (x [0][1]*x [1][2]-x [0][2]*x [1][1]) / det;
	a.x [1][0] = (x [1][2]*x [2][0]-x [1][0]*x [2][2]) / det;
	a.x [1][1] = (x [0][0]*x [2][2]-x [0][2]*x [2][0]) / det;
	a.x [1][2] = (x [0][2]*x [1][0]-x [0][0]*x [1][2]) / det;
	a.x [2][0] = (x [1][0]*x [2][1]-x [1][1]*x [2][0]) / det;
	a.x [2][1] = (x [0][1]*x [2][0]-x [0][0]*x [2][1]) / det;
	a.x [2][2] = (x [0][0]*x [1][1]-x [0][1]*x [1][0]) / det;

	return *this = a;
}

Matrix4D&	Matrix4D :: transpose ()
{
	Matrix4D a;

	a.x [0][0] = x [0][0];
	a.x [0][1] = x [1][0];
	a.x [0][2] = x [2][0];
	a.x [0][3] = x [3][0];

	a.x [1][0] = x [0][1];
	a.x [1][1] = x [1][1];
	a.x [1][2] = x [2][1];
	a.x [1][3] = x [3][1];
	
	a.x [2][0] = x [0][2];
	a.x [2][1] = x [1][2];
	a.x [2][2] = x [2][2];
	a.x [2][3] = x [3][2];
	
	a.x [3][0] = x [0][3];
	a.x [3][1] = x [1][3];
	a.x [3][2] = x [2][3];
	a.x [3][3] = x [3][3];
	
	

	return *this = a;
}

Matrix4D operator + ( const Matrix4D& a, const Matrix4D& b )
{
	Matrix4D c;

	c.x [0][0] = a.x [0][0] + b.x [0][0];
	c.x [0][1] = a.x [0][1] + b.x [0][1];
	c.x [0][2] = a.x [0][2] + b.x [0][2];
	c.x [0][3] = a.x [0][3] + b.x [0][3];
	
	c.x [1][0] = a.x [1][0] + b.x [1][0];
	c.x [1][1] = a.x [1][1] + b.x [1][1];
	c.x [1][2] = a.x [1][2] + b.x [1][2];
	c.x [1][3] = a.x [1][3] + b.x [1][3];
	
	c.x [2][0] = a.x [2][0] + b.x [2][0];
	c.x [2][1] = a.x [2][1] + b.x [2][1];
	c.x [2][2] = a.x [2][2] + b.x [2][2];
	c.x [2][3] = a.x [2][3] + b.x [2][3];
	
	c.x [3][0] = a.x [3][0] + b.x [3][0];
	c.x [3][1] = a.x [3][1] + b.x [3][1];
	c.x [3][2] = a.x [3][2] + b.x [3][2];
	c.x [3][3] = a.x [3][3] + b.x [3][3];

	return c;
}

Matrix4D operator - ( const Matrix4D& a, const Matrix4D& b )
{
	Matrix4D c;


	c.x [0][0] = a.x [0][0] - b.x [0][0];
	c.x [0][1] = a.x [0][1] - b.x [0][1];
	c.x [0][2] = a.x [0][2] - b.x [0][2];
	c.x [0][3] = a.x [0][3] - b.x [0][3];
	
	c.x [1][0] = a.x [1][0] - b.x [1][0];
	c.x [1][1] = a.x [1][1] - b.x [1][1];
	c.x [1][2] = a.x [1][2] - b.x [1][2];
	c.x [1][3] = a.x [1][3] - b.x [1][3];
	
	c.x [2][0] = a.x [2][0] - b.x [2][0];
	c.x [2][1] = a.x [2][1] - b.x [2][1];
	c.x [2][2] = a.x [2][2] - b.x [2][2];
	c.x [2][3] = a.x [2][3] - b.x [2][3];
	
	c.x [3][0] = a.x [3][0] - b.x [3][0];
	c.x [3][1] = a.x [3][1] - b.x [3][1];
	c.x [3][2] = a.x [3][2] - b.x [3][2];
	c.x [3][3] = a.x [3][3] - b.x [3][3];

	return c;
}

Matrix4D operator * ( const Matrix4D& a, const Matrix4D& b )
{
	Matrix4D c ( a );


	c.x[0][0]=a.x[0][0]*b.x[0][0]+a.x[0][1]*b.x[1][0]+a.x[0][2]*b.x[2][0]+a.x[0][3]*b.x[3][0];
	c.x[0][1]=a.x[0][0]*b.x[0][1]+a.x[0][1]*b.x[1][1]+a.x[0][2]*b.x[2][1]+a.x[0][3]*b.x[3][1];
	c.x[0][2]=a.x[0][0]*b.x[0][2]+a.x[0][1]*b.x[1][2]+a.x[0][2]*b.x[2][2]+a.x[0][3]*b.x[3][2];
	c.x[0][3]=a.x[0][0]*b.x[0][3]+a.x[0][1]*b.x[1][3]+a.x[0][2]*b.x[2][3]+a.x[0][3]*b.x[3][3];
	
	c.x[1][0]=a.x[1][0]*b.x[0][0]+a.x[1][1]*b.x[1][0]+a.x[1][2]*b.x[2][0]+a.x[1][3]*b.x[3][0];
	c.x[1][1]=a.x[1][0]*b.x[0][1]+a.x[1][1]*b.x[1][1]+a.x[1][2]*b.x[2][1]+a.x[1][3]*b.x[3][1];
	c.x[1][2]=a.x[1][0]*b.x[0][2]+a.x[1][1]*b.x[1][2]+a.x[1][2]*b.x[2][2]+a.x[1][3]*b.x[3][2];
	c.x[1][3]=a.x[1][0]*b.x[0][3]+a.x[1][1]*b.x[1][3]+a.x[1][2]*b.x[2][3]+a.x[1][3]*b.x[3][3];
	
	c.x[2][0]=a.x[2][0]*b.x[0][0]+a.x[2][1]*b.x[1][0]+a.x[2][2]*b.x[2][0]+a.x[2][3]*b.x[3][0];
	c.x[2][1]=a.x[2][0]*b.x[0][1]+a.x[2][1]*b.x[1][1]+a.x[2][2]*b.x[2][1]+a.x[2][3]*b.x[3][1];
	c.x[2][2]=a.x[2][0]*b.x[0][2]+a.x[2][1]*b.x[1][2]+a.x[2][2]*b.x[2][2]+a.x[2][3]*b.x[3][2];
	c.x[2][3]=a.x[2][0]*b.x[0][3]+a.x[2][1]*b.x[1][3]+a.x[2][2]*b.x[2][3]+a.x[2][3]*b.x[3][3];
	
	c.x[3][0]=a.x[3][0]*b.x[0][0]+a.x[3][1]*b.x[1][0]+a.x[3][2]*b.x[2][0]+a.x[3][3]*b.x[3][0];
	c.x[3][1]=a.x[3][0]*b.x[0][1]+a.x[3][1]*b.x[1][1]+a.x[3][2]*b.x[2][1]+a.x[3][3]*b.x[3][1];
	c.x[3][2]=a.x[3][0]*b.x[0][2]+a.x[3][1]*b.x[1][2]+a.x[3][2]*b.x[2][2]+a.x[3][3]*b.x[3][2];
	c.x[3][3]=a.x[3][0]*b.x[0][3]+a.x[3][1]*b.x[1][3]+a.x[3][2]*b.x[2][3]+a.x[3][3]*b.x[3][3];

	return c;
}

Matrix4D operator * ( const Matrix4D& a, float b )
{
	Matrix4D c ( a );

	return (c *= b);
}

Matrix4D operator * ( float b, const Matrix4D& a )
{
	Matrix4D c ( a );

	return (c *= b);
}

Matrix4D	Matrix4D :: getIdentityMatrix ()
{
	return Matrix4D ( 1 );
}

