#ifndef ERROR_CHECK_H
#define ERROR_CHECK_H





#ifdef _DEBUG

#define CHECK_GL_ERROR() CheckGLError(__FILE__, __LINE__)
#define CHECK_DI_ERROR() CheckDIError(__FILE__, __LINE__)

#define FATALERROR ( g_szFatalErrorFile = __FILE__\
                   , g_nFatalErrorLine = __LINE__\
                   , g_szFatalErrorFunc = __FUNCTION__\
                   , 0) ? FatalError(NULL) : FatalError
#define DEBUGMSG   ( g_szFatalErrorFile = __FILE__\
                   , g_nFatalErrorLine = __LINE__\
                   , g_szFatalErrorFunc = __FUNCTION__\
                   , 0) ? FatalError(NULL) : DebugMessage
                   
#define ASSERT(condition,...) { if (!(condition)) FATALERROR(__VA_ARGS__); }
#define ASSERTNOT(condition,...) { if (condition) FATALERROR(__VA_ARGS__); }
#define ASSERT_EXP(condition) { if (!(condition)) FATALERROR("Failed "#condition); }
#define ASSERTNOT_EXP(condition) { if (condition) FATALERROR(#condition); }

extern char *g_szFatalErrorFile;
extern int   g_nFatalErrorLine;
extern char *g_szFatalErrorFunc;
#else
#define CHECK_DI_ERROR() 
#define CHECK_GL_ERROR()

//#define FATALERROR(...) 
//#define DEBUGMSG(...) 

#define FATALERROR ( g_szFatalErrorFile = __FILE__\
                   , g_nFatalErrorLine = __LINE__\
                   , g_szFatalErrorFunc = __FUNCTION__\
                   , 0) ? FatalError(NULL) : FatalError
#define DEBUGMSG   ( g_szFatalErrorFile = __FILE__\
                   , g_nFatalErrorLine = __LINE__\
                   , g_szFatalErrorFunc = __FUNCTION__\
                   , 0) ? FatalError(NULL) : DebugMessage
                   
extern char *g_szFatalErrorFile;
extern int   g_nFatalErrorLine;
extern char *g_szFatalErrorFunc;
                  
#define ASSERT(condition,...)
#define ASSERTNOT(condition,...)
#define ASSERT_EXP(condition) 
#define ASSERTNOT_EXP(condition)
#endif

void FatalError(const char *fmt = "", ...);
void DebugMessage(const char *fmt = "", ...);
void Assert(bool b, const char *fmt = "", ...);
void AssertNot(bool b, const char *fmt = "", ...);
int	 CheckGLError(char *file, int line);
int	 CheckDIError(char *file, int line);

#ifndef assert
#define assert(f) ("Use ASSERT instead of assert")
#endif

extern char* aGLSLErrorString[];

#endif

#include "MemoryMan.h"