#ifndef GLOBALS_HPP
#define GLOBALS_HPP

#include "Stdafx.h"

#include "Types/Vector3D.h"
#include "Types/Matrix3D.h"

class CProperties;

enum  EProgramType
{
	PT_NORMAL			= 0,			//Terrain & Models are loaded to the sector grid
	PT_EDITINGTERRAIN	= 1,			//Model arent loaded , terrain doesnt load into the sector grid
	PT_EDITINGMODELS	= 2				//Terrain is loadead to the sector grid, models are not
};


struct SApplicationValues
{
	HDC				hDC;					// GDI
	HGLRC			hRC;					// Rendering'o contekstas
	HWND			hWnd;					
	HINSTANCE		hInstance;				
	bool			bActive;	
	bool			bFullScreen;
	char			strMainDir[512];	
	EProgramType	eAppType;	

};

extern SApplicationValues g_sApp;
extern bool			g_bGLSL_Supported;

//Program Time
extern float		g_fTime;
extern float		g_fFrameTime;
extern unsigned int g_nFrameCount;

extern float		g_nUpdateTime;
extern unsigned int g_nUpdateRepeatCount;

//Application properties loaded from xml
extern CProperties *g_pcAppProps;

bool				AppInit();		
void				AppDeInit();

namespace ShaderVals
{
	extern float	g_fShTime;			//Grows from 0.0f to infinity
	extern float	g_fShLoopTime;		//Grows from 0.0 to 1.0, then again begins from 0.0 ...
	extern float	g_fShHillTime;		//Grows from 0.0 to 1.0, from 1.0 to 0.0, from 0.0 to 1.0
	extern float	g_fShHillCof;
	extern float    g_fShSinus;
	extern float	g_fShCosinus;
	extern Vector3D g_vEye;				//Camera Eye
	extern Vector3D g_vCurPosition;		//Current Position;
	extern Vector3D g_vCurScale;
	extern Matrix3D g_mCurRotation;
};


#endif